@extends('backend.layouts.app')

@section('title') {{$module_action}} {{$module_title}} @endsection

@section('breadcrumbs')
<x-backend-breadcrumbs>
    <x-backend-breadcrumb-item route='{{route("backend.$module_name.index")}}' icon='{{ $module_icon }}'>
        {{$module_title}}
    </x-backend-breadcrumb-item>
    <x-backend-breadcrumb-item type="active">{{$module_action}}</x-backend-breadcrumb-item>
</x-backend-breadcrumbs>
@endsection

@section('content')


<style type="text/css">
    .form-control:focus {
    background-color: #fff;
    border-color: #f700f0;
     box-shadow:unset; 
}
.select2-container--bootstrap .select2-results__option--highlighted[aria-selected] {
    background-color: #f800f2;
}
.select2-container--bootstrap.select2-container--focus .select2-selection, .select2-container--bootstrap.select2-container--open .select2-selection {
    border-color: #f800f2;
}
.select2-container--bootstrap .select2-dropdown {
    border-color: #f800f2;
}

.text-danger {
    display: none;
}

.form-group {
    padding: 0px;
    padding-bottom: 1rem;
}
.change-thumbnail {
       box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important; 
}
.change-thumbnail:hover,.change-thumbnail:focus,.change-thumbnail:visited{
    box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important; 
}
.change-thumbnail:active{
   box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important;   
}
.input-thumbnail {
        opacity: 0;
        position: absolute;
        display: inline-block;
        width: 149px;
        padding: 0px;
        margin: -4px;
        margin-left: -37px;
        cursor: pointer;
}
span.select2.select2-container.select2-container--bootstrap{
    width: auto !important;
}
label,.form-check-label {
    color: grey;
}

.form-check-input{
    background-color: white;
}
.form-check-input:focus {
    background-color: #ffffff;
    border-color: #80808096;
    box-shadow: none;
}
.form-check-input:checked{
    background-color: #f800f2;
    border-color: #f800f2;
    box-shadow: none;
}

/*pop over show action icon*/
 /*on hover image pop up button*/
  .popup-container {
  position: relative;
  /*width: 50%;*/
}

.popup-image {
  opacity: 1;
  display: block;
  width: 100%;
  height: auto;
  transition: .5s ease;
  backface-visibility: hidden;
}

.popup-middle {
  transition: .5s ease;
  opacity: 0;
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  -ms-transform: translate(-50%, -50%);
  text-align: center;
}

.popup-container:hover .popup-image {
  opacity: 0.3;
}

.popup-container:hover .popup-middle {
  opacity: 1;
}

.popup-text {
  /*background-color:#f800f2;*/
  color: white;
  font-size: 16px;
  padding: 16px 32px;
}
.popup-text> i {
    padding: 4px;
}
.popup-container:hover .popup-image {
    opacity: 0.6;
    box-shadow: 0px 0px 9px #f800f2;
}

.upload-new-image{
    display: inline-block;
    width: 40%;
    margin: 4px;
}
.upload-new-image:visited{
    background: green;
}

</style>




<div class="card">
    <div class="card-body">
        <x-backend.section-header>
            <i class="{{ $module_icon }}"></i> {{$module_title}} <small class="text-muted"> {{ $module_action}}</small>

            <x-slot name="subtitle">@lang('labels.backend.users.edit.sub-title')
            {{--    @lang(":module_name Management Dashboard", ['module_name'=>Str::title($module_name)])--}}
            {{--gt::trans('Posts Management Dashboard',app()->getLocale())--}}
            </x-slot>
            <x-slot name="toolbar">
                
                <button onclick="window.history.back();" class="btn change-thumbnail ms-1 " data-toggle="tooltip" aria-label="Return Back" data-coreui-original-title=" @lang('labels.text.return_back') "><i class="fas fa-reply"></i>&nbsp;</button>

                     <a href='{!!route("backend.$module_name.show",$$module_name_singular->id)!!}' class="btn change-thumbnail ms-1" data-toggle="tooltip" title=" @lang('labels.text.show') {{ ucwords(Str::singular($module_name)) }}"><i class="fas fa-desktop"></i></a>

            </x-slot>
        </x-backend.section-header>

<!--  auto renew option -->

<div class="row mb-3">
<!-- <div class="col-2">
    <a href='{{ route("backend.$module_name.create") }}'>
   <button class="btn btn-success"><i class="fas fa-plus-circle me-1"></i>Add Post </button>
    </a>
</div>
<div class="col-3">
         <form method="Post" action='{{ route("backend.$module_name.autorenew",$$module_name_singular->id) }}' class="form" >@csrf
                <button class="btn btn-success"><i class="fa fa-refresh me-1"></i>AutoNew </button>
         </form>

</div>              -->
</div> 

        <hr>

        <div class="row mt-1">
            <div class="col">
        

                @include ("article::backend.$module_name.edit_ad")

                <div class="row mt-3">
                    

                    <div class="col-12">
                        <div class="" style="display:flex;justify-content:space-between;">

                            @can('delete_'.$module_name)
                            <a href='{{route("backend.$module_name.destroy", $$module_name_singular->id)}}' class="btn change-thumbnail" data-method="DELETE" data-token="{{csrf_token()}}" data-toggle="tooltip" title=" @lang('labels.backend.delete')"><i class="fas fa-trash-alt"></i></a>
                            @endcan
                            <a href='{{ route("backend.$module_name.index") }}' class="btn change-thumbnail" data-toggle="tooltip" title=" @lang('labels.backend.cancel')"><i class="fas fa-reply"></i> @lang('labels.backend.cancel')</a>
                        </div>
                    </div>
                </div>
             

            </div>
        </div>
    </div>





    <div class="card-footer">
        <div class="row">
            <div class="col">
                <small class="float-end text-muted">
                 @lang('labels.backend.users.fields.updated_at'): {{$$module_name_singular->updated_at->diffForHumans()}},
                  @lang('labels.backend.users.fields.created_at'): {{$$module_name_singular->created_at->isoFormat('LLLL')}}
                </small>
            </div>
        </div>
    </div>
</div>



@endsection