@extends('backend.layouts.app')
@section('title') @lang('labels.text.freerenew') @lang('labels.text.post')   @endsection
@section('breadcrumbs')
<x-backend-breadcrumbs>
    <span style="color:grey"> / @lang('labels.text.freerenew') </span>
</x-backend-breadcrumbs>
@endsection
@section('content')
<!-- message to show 3 free ads/day -->
@if($limit_three_ad_per_day ==true)
    <div class="alert alert-danger text-capitalize"> @lang('labels.text.can_not_post_more_than_three_in_a_day')</div>
@endif
<div class="text-end mb-2">
<x-backend.buttons.return-back />
 </div>
<div class="row d-flex justify-content-center">
    <div class="col-sm-6 col-lg-3">
        <div class="card mb-4">
            <div class="card-body">
                <div class="fs-4 fw-semibold">@lang('labels.text.free_renew_ad')</div>
                <small class="text-medium-emphasis">@lang('labels.text.ad_visible_after_24hr')</small>
            </div>
            <div class="card-footer px-3 py-2">
                  <button data-bs-toggle="modal" data-bs-target="#exampleModal12"
                        class="btn btn-success">@lang('labels.text.renew')</button>
                    <!-- Modal -->
                    <div class="modal fade" id="exampleModal12" tabindex="-1" aria-labelledby="exampleModalLabel"
                        aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">@lang('labels.text.free_renew_ad')</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                     @if(isset($time24hnotover))
                                              {{$time24hnotover}}  
                                        @else
                        <p>@lang('labels.text.free_renew_ad')</p>
                        <strong>@lang('labels.text.one_time_post_in_24hr')</strong>
                        <strong></strong>
                                     @endif
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary"
                                        data-bs-dismiss="modal">@lang('labels.buttons.general.close')</button>
                                         @if(!isset($time24hnotover))
                                            <form method="Post" action='{{route("backend.$module_name.freerenewupdate")}}' class="form">
                                    @csrf
                                    <input type="hidden" name="postid" value="{{$postid}}">
                                    <input type="hidden" name="userid" value="{{$userid}}">
                                    <input type="hidden" name="time" value="24">
                                    <button type="submit" class="btn btn-primary">@lang('labels.text.renew')</button>
                                </form>
                                        @endif
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
        </div>
    </div>
    <!-- /.col-->
    <div class="col-sm-6 col-lg-3">
        <div class="card mb-4">
            <div class="card-body">
                <div class="fs-4 fw-semibold">@lang('labels.text.paid_renew_ad')</div>
                <small class="text-medium-emphasis">@lang('labels.text.choose_frequency')</small>
            </div>
            <div class="card-footer px-3 py-2">
                <a class="btn-block text-medium-emphasis d-flex justify-content-between align-items-center"
                    href='{!!route("backend.$module_name.autorenew", $data)!!}'><span class="small fw-semibold">@lang('labels.text.view_more')</span>
                    <svg class="icon">
                        <use xlink:href="/fonts/free.svg#cil-chevron-right"></use>
                    </svg>
                </a>
            </div>
        </div>
    </div>
    <!-- /.col-->
</div>
<!-- countdown clock  start-->
<!-- Display the countdown timer in an element -->
 @if($settime_is_30day == 'yes')   
                        <h3 class="text-center" id="inactivedemo"></h3>
                  @else
                        <h3 class="text-center" id="demo"></h3>
                  @endif 
<!-- countdown clock end -->
<!--  for admin  start-->
<div class="row text-center d-flex justify-content-center">
    <h3 class="text-center"><span class="badge bg-secondary fs-6">{{$paidOrFreeAdStatus}}</span></h3>
</div>
<div class="container">
    <table class="table">
        <thead>
            <tr></tr>
        </thead>
        <tbody>
            <tr style="text-align: center;">
                 @if($removead=='yes')
                <td>
                    <button data-bs-toggle="modal" data-bs-target="#exampleModal345"
                        class="btn btn-danger">@lang('labels.text.remove_ad')</button>
                    <!-- Modal -->
                    <div class="modal fade" id="exampleModal345" tabindex="-1" aria-labelledby="exampleModalLabel"
                        aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">@lang('labels.text.remove_post')</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                     <strong>@lang('labels.text.your_post_remove_from_home_page')</strong>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary"
                                        data-bs-dismiss="modal">@lang('labels.buttons.general.close')</button>
                                    <form method="Post" action='{{route("backend.$module_name.freerenewupdate")}}'
                                        class="form">
                                        @csrf
                                        <input type="hidden" name="removead" value="yes">
                                        <input type="hidden" name="postid" value="{{$postid}}">
                                        <button type="submit" class="btn btn-danger">@lang('labels.text.Remove')</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    </form>
                </td>
                 @endif
            </tr>
        </tbody>
    </table>
</div>
@endsection
@push ('after-styles')
<!-- DataTables Core and Extensions -->
<link rel="stylesheet" href="{{ asset('vendor/datatable/datatables.min.css') }}">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
    integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous" />
@endpush
@push ('after-scripts')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
<script src = "https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
<script>
setInterval(function(){
        $.ajax({
       type:'POST',
        data:{'_token':"{{csrf_token()}}"},
        url:'{{route("backend.$module_path.gettime",["slug"=> $slug])}}',
        success:function(data) {
            gettime(data);
        },
        error: function(data){
            console.log("error");
        }
        });
 },1000);
function gettime(ad) {
        var finish=new Date();
        finish.setFullYear(ad.year,ad.month,ad.day);
        finish.setHours(ad.hour);
        finish.setMinutes(ad.minute);
        finish.setSeconds(ad.second);
        finish.toLocaleString('en',{timeZone: 'Europe/Madrid'});
        finish.getTime();
        var countDownDate=finish;
        // Update the count down every 1 second
        var x = setInterval(function() {
          // Get today's date and time
          // var now = new Date( new Date().toLocaleString('en', {timeZone: 'Europe/Madrid'}) );
          // console.log('current data',now);
          var now = new Date( new Date().toLocaleString('en', {timeZone: 'Europe/Madrid'}) ).getTime();
          // Find the distance between now and the count down date
          var distance = countDownDate - now;
          // Time calculations for days, hours, minutes and seconds
          var days = Math.floor(distance / (1000 * 60 * 60 * 24));
          var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
          var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
          var seconds = Math.floor((distance % (1000 * 60)) / 1000);
          var time = distance / 1000;
          var day = Math.floor(time / (24*60*60));
          var checkfinishdate=day;
          // Display the result in the element with id="demo"
          if(document.getElementById("demo")){
              document.getElementById("demo").innerHTML =
              `<span class="small countdowntimer"><?php echo trans('labels.text.time_left'); ?></span>
             <button  class="btn btn-danger" id='clock_result'>${hours}:${minutes}:${seconds}</button>`;
          }
           // if 30 day ad is running
              if(checkfinishdate < 1 && document.getElementById("inactivedemo")){
                document.getElementById("inactivedemo").innerHTML =`<span class="small countdowntimer">
                <?php echo trans('labels.text.time_left'); ?></span><button  class="btn btn-danger" id='clock_result'><?php echo trans('labels.text.expired'); ?></button>`;;    
              }else{
                    if(document.getElementById("inactivedemo")){
                        document.getElementById("inactivedemo").innerHTML =`<span class="small countdowntimer">
                        <?php echo trans('labels.text.time_left'); ?></span>
                        <button  class="btn btn-danger" id='clock_result'>${checkfinishdate} <?php echo trans('labels.text.days_left'); ?>
                        </button>`; 
                    }
              }
        // If the count down is finished, write some text
          if (distance < 0) {
            clearInterval(x);
            if(document.getElementById("demo")){
                document.getElementById("demo").innerHTML = `<span class="small countdowntimer"><?php echo trans('labels.text.time_left'); ?></span>
                <button  class="btn btn-danger " id='clock_result'><?php echo trans('labels.text.expired'); ?></button>`;
            }
    }
            }, 1000);
}

</script>
@endpush