@extends('backend.layouts.app')

@section('title') {{$module_action}} {{$module_title}} @endsection

@section('breadcrumbs')
<x-backend-breadcrumbs>
    <x-backend-breadcrumb-item type="active" icon='{{ $module_icon }}'>@lang('labels.text.rooms')</x-backend-breadcrumb-item>
</x-backend-breadcrumbs>
@endsection

<style>
    body,table{
        color: grey !important;
        }
        table a{
        text-decoration:none;    
        color:grey;
        }
        table  a:hover{
            color:inherit;
        }
        i{
            padding:3px;
        }
        .form-select:focus {
          border-color:grey !important;
          box-shadow: none !important;
        }
        .small, small {
            text-transform: capitalize;
        }
        .plusIcon{
            font-size: x-large !important;
        }
        @media (min-width: 1024px){
            .menu-card{
                left: 80%;
            }
        }
        
        @media (max-width: 1024px){
            .menu-card{
                left: 70%;
            }
        }
        @media (max-width: 768px){
            .card-body.list .btn-toolbar.d-block a {
                width: 89px !important;
            }
            .totalCredits{
                font-size: 15px !important;
            }
            .menu-card{
                left: 50%;
            }
        }

        @media (max-width: 425px){

            .plusIcon{
                font-size: large !important;
            }
            .card-body.list .btn-toolbar.d-block {
                width: 70% !important;
            }

            .card-body.list .btn-toolbar.d-block a {
                width: 63px !important;
            }
            
        }
        @media (max-width: 375px){
            .menu-card{
                left: 65%;
            }
            .card-body.list .btn-toolbar.d-block {
                width: 53% !important;
            }
        }

        @media (max-width: 320px){
            .card-body.list .btn-toolbar.d-block {
                width: 65% !important;
            }

            .card-body.list .btn-toolbar.d-block a {
                width: 34px !important;
            }
            .menu-card{
                left: 60%;
            }
        }

</style>

@section('content')


@php 
 $rolename=auth()->user()->getRoleNames()[0];
@endphp
<!--<div class="card-body list">-->
<!--    <p class="text-center text-danger">Nude images and some others that may be particularly provocative will no longer be displayed on our website. On the other hand, we would like to emphasize that professional photographs will have priority on our website. Thanks for your understanding!</p>-->
<!--</div>-->


<div class="card">
    <div class="card-body list">

        <div class="d-flex d-mb-block justify-content-between flex-wrap mb-3">
            <div>
                <h4 class="card-title mb-0">
                    <i class="{{ $module_icon }}"></i> <small class="text-muted">@lang('labels.text.rooms')</small>
                </h4>
               
             </div>
        <div>
             @if($rolename=='escort')
    
                    <a class="btn change-thumbnail ms-1" href='{{ route("backend.$module_name.roomcreate") }}'
                       data-toggle="tooltip" aria-label="Create Room" 
                      data-coreui-original-title="@lang('labels.text.create_room')" style="box-shadow: none;border: 1px solid #3600f8 !important;background: white;color: #3600f8 !important; font-size:inherit !important;">
                            <i class="fa fa-plus-square plusIcon" aria-hidden="true" style="font-size:inherit !important;"></i>@lang('labels.text.create_room')
                    </a>
                    @endif
    </div>
    <div class="btn-toolbar d-block" role="toolbar" aria-label="Toolbar with buttons">
       
                                        
                @if($rolename=='escort')
                <span class="totalCredits" style="float: right;color: grey;font-size: larger;text-transform: uppercase;">@lang('labels.text.total_credits'): @if(isset($credits)) 
                      @if($credits !=null)
                                    {{$credits}}
                            @else
                                        0
                        @endif
                @endif</span>
                    @endif
    </div>
</div>





  @if($rolename == 'super admin')


    <!--  show all posts for Admin -->

        <div class="row mt-4">
            <div class="col">
                <table id="datatable" class="table table-bordered table-hover table-responsive-sm">
                    <thead>
                    <tr>
                            <th>
                              @lang('labels.text.id')
                        </th>
                            <th>
                               @lang('labels.text.title')
                         </th>
                            <th>
                                @lang('labels.text.town')
                            </th> 
                            <th>
                               @lang('labels.text.rates')
                            </th>
    
                            <th>
                               @lang('labels.backend.users.fields.updated_at')

                            </th>
                            
                            <th class="text-end">
                              @lang('labels.text.action')
                            </th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>

    <!--  end show all posts for admin -->

  @endif

    <!--  show all posts for agency -->

 

    <!--  show all posts for agency -->




  @if($rolename == 'escort')


@php 

 $date_array=[];
 $slugarr=[];

@endphp
  
<div class="row row-cols-lg-4 row-cols-md-4">
@foreach($data as $post)
     
  <div class="col-lg-6 col-md-6 col-sm-6 mb-6"> 
    <div class="card h-100" style="width: 100%;">
    @if(isset($post->imageFile[0]))
      <img onclick="window.location.href = '{{route("backend.$module_name.show",$post->id)}}'" src="{{URL::to('/');}}/public/images/userimage/{{$module_name}}/{{$post->id}}/{{$post->imageFile[0]}}" class="card-img-top" alt="image" style="height: 287px;width: 100%; cursor:pointer">
      @else
                        <svg onclick="window.location.href = '{{route("backend.$module_name.show",$post->id)}}'" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="100%" height="250px" style = "cursor:pointer" viewBox="0 0 256 256" xml:space="preserve">
                            <defs>
                            </defs>
                            <g style="stroke: none; stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: none; fill-rule: nonzero; opacity: 1;" transform="translate(1.4065934065934016 1.4065934065934016) scale(2.81 2.81)">
                                <path d="M 89 80.376 H 1 V 60.401 c 0 -5.25 4.256 -9.505 9.505 -9.505 h 68.99 c 5.25 0 9.505 4.256 9.505 9.505 V 80.376 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(239,237,239); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 83.13 86.246 h -1.337 c -3.242 0 -5.87 -2.628 -5.87 -5.87 l 0 0 H 89 l 0 0 C 89 83.618 86.372 86.246 83.13 86.246 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(185,185,185); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 85.592 53.112 V 32.86 c 0 -3.72 -2.321 -6.892 -5.59 -8.166 v -4.154 c 1.213 -0.697 2.039 -1.991 2.039 -3.49 c 0 -2.232 -1.809 -4.041 -4.041 -4.041 s -4.041 1.809 -4.041 4.041 c 0 1.499 0.826 2.793 2.039 3.49 v 3.55 h -22.72 H 36.573 H 14.002 v -3.55 c 1.213 -0.697 2.039 -1.991 2.039 -3.49 c 0 -2.232 -1.809 -4.041 -4.041 -4.041 s -4.041 1.809 -4.041 4.041 c 0 1.499 0.826 2.793 2.039 3.49 v 4.154 c -3.27 1.274 -5.59 4.445 -5.59 8.166 v 20.252 H 85.592 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(239,237,239); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 57.749 6.337 c -2.941 -3.322 -8.511 -3.734 -12.824 0.508 c -4.313 -4.242 -9.883 -3.83 -12.824 -0.508 c -3.128 3.534 -1.814 10.13 2.304 15.402 c 2.087 2.672 7.244 7.023 10.52 8.85 c 3.275 -1.827 8.432 -6.179 10.52 -8.85 C 59.564 16.467 60.878 9.871 57.749 6.337 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(254,147,211); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 8.208 86.246 H 6.87 c -3.242 0 -5.87 -2.628 -5.87 -5.87 l 0 0 h 13.078 l 0 0 C 14.078 83.618 11.45 86.246 8.208 86.246 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(185,185,185); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 89 63.863 H 1 c 0 0 0 -3.462 0 -3.462 c 0 -5.25 4.256 -9.505 9.505 -9.505 h 68.99 c 5.25 0 9.505 4.256 9.505 9.505 C 89 60.401 89 63.863 89 63.863 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(254,254,254); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 42.417 50.826 H 14.078 v 0 c 0 -6.435 5.217 -11.652 11.652 -11.652 h 5.036 C 37.2 39.174 42.417 44.391 42.417 50.826 L 42.417 50.826 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(254,254,254); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 75.922 50.826 H 47.583 v 0 c 0 -6.435 5.217 -11.652 11.652 -11.652 h 5.036 C 70.705 39.174 75.922 44.391 75.922 50.826 L 75.922 50.826 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(254,254,254); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 44.925 31.589 c -0.168 0 -0.336 -0.042 -0.487 -0.126 c -3.375 -1.883 -8.634 -6.31 -10.82 -9.108 c -4.626 -5.922 -5.579 -12.937 -2.265 -16.68 c 1.589 -1.794 3.819 -2.83 6.28 -2.915 c 2.568 -0.102 5.121 0.875 7.293 2.729 c 2.171 -1.854 4.728 -2.832 7.293 -2.729 c 2.461 0.085 4.691 1.12 6.279 2.915 c 3.313 3.743 2.361 10.758 -2.265 16.68 c -2.188 2.799 -7.446 7.226 -10.821 9.108 C 45.261 31.547 45.093 31.589 44.925 31.589 z M 37.956 4.754 c -0.085 0 -0.169 0.001 -0.254 0.004 C 35.794 4.824 34.071 5.62 32.85 7 c -2.631 2.973 -1.624 9.045 2.344 14.124 c 1.919 2.457 6.581 6.419 9.731 8.31 c 3.15 -1.89 7.812 -5.853 9.732 -8.31 C 58.625 16.044 59.632 9.972 57 7 c 0 0 0 0 0 0 c -1.221 -1.379 -2.943 -2.175 -4.851 -2.241 c -2.288 -0.079 -4.606 0.916 -6.523 2.799 c -0.389 0.383 -1.014 0.383 -1.402 0 C 42.379 5.743 40.163 4.754 37.956 4.754 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 35.351 14.601 c -0.424 0 -0.818 -0.273 -0.953 -0.699 c -0.611 -1.935 -0.371 -3.71 0.658 -4.873 c 1.12 -1.265 2.873 -1.745 4.575 -1.25 c 0.53 0.154 0.835 0.709 0.682 1.239 c -0.154 0.53 -0.708 0.834 -1.239 0.682 c -0.951 -0.277 -1.918 -0.025 -2.521 0.655 c -0.552 0.624 -0.642 1.697 -0.248 2.944 c 0.167 0.527 -0.126 1.088 -0.652 1.255 C 35.553 14.586 35.451 14.601 35.351 14.601 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 89 81.376 H 1 c -0.552 0 -1 -0.447 -1 -1 V 60.4 c 0 -5.792 4.713 -10.505 10.505 -10.505 h 68.99 C 85.287 49.896 90 54.608 90 60.4 v 19.976 C 90 80.929 89.553 81.376 89 81.376 z M 2 79.376 h 86 V 60.4 c 0 -4.689 -3.815 -8.505 -8.505 -8.505 h -68.99 C 5.815 51.896 2 55.711 2 60.4 V 79.376 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 42.417 51.826 H 14.078 c -0.552 0 -1 -0.447 -1 -1 c 0 -6.976 5.675 -12.652 12.651 -12.652 h 5.036 c 6.976 0 12.651 5.676 12.651 12.652 C 43.417 51.379 42.969 51.826 42.417 51.826 z M 15.125 49.826 h 26.246 c -0.506 -5.406 -5.069 -9.652 -10.605 -9.652 h -5.036 C 20.194 40.174 15.63 44.42 15.125 49.826 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 75.922 51.826 H 47.583 c -0.553 0 -1 -0.447 -1 -1 c 0 -6.976 5.676 -12.652 12.651 -12.652 h 5.036 c 6.976 0 12.651 5.676 12.651 12.652 C 76.922 51.379 76.475 51.826 75.922 51.826 z M 48.63 49.826 h 26.245 c -0.506 -5.406 -5.068 -9.652 -10.604 -9.652 h -5.036 C 53.698 40.174 49.136 44.42 48.63 49.826 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 89 64.862 H 1 c -0.552 0 -1 -0.447 -1 -1 s 0.448 -1 1 -1 h 88 c 0.553 0 1 0.447 1 1 S 89.553 64.862 89 64.862 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 8.208 87.246 H 6.871 C 3.082 87.246 0 84.164 0 80.376 c 0 -0.553 0.448 -1 1 -1 h 13.078 c 0.552 0 1 0.447 1 1 C 15.078 84.164 11.996 87.246 8.208 87.246 z M 2.103 81.376 c 0.463 2.207 2.425 3.87 4.768 3.87 h 1.337 c 2.343 0 4.305 -1.663 4.768 -3.87 H 2.103 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 83.13 87.246 h -1.338 c -3.788 0 -6.87 -3.082 -6.87 -6.87 c 0 -0.553 0.447 -1 1 -1 H 89 c 0.553 0 1 0.447 1 1 C 90 84.164 86.918 87.246 83.13 87.246 z M 77.025 81.376 c 0.462 2.207 2.424 3.87 4.767 3.87 h 1.338 c 2.343 0 4.305 -1.663 4.767 -3.87 H 77.025 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 4.408 54.112 c -0.552 0 -1 -0.447 -1 -1 V 32.86 c 0 -3.82 2.172 -7.212 5.59 -8.824 v -2.958 c -1.27 -0.946 -2.039 -2.441 -2.039 -4.028 c 0 -2.779 2.261 -5.041 5.041 -5.041 s 5.041 2.261 5.041 5.041 c 0 1.587 -0.769 3.082 -2.039 4.028 v 2.013 h 21.571 c 0.552 0 1 0.448 1 1 s -0.448 1 -1 1 H 14.002 c -0.552 0 -1 -0.448 -1 -1 v -3.55 c 0 -0.358 0.191 -0.688 0.501 -0.867 c 0.962 -0.554 1.537 -1.535 1.537 -2.624 c 0 -1.677 -1.364 -3.041 -3.041 -3.041 s -3.041 1.364 -3.041 3.041 c 0 1.089 0.575 2.07 1.537 2.624 c 0.31 0.178 0.501 0.509 0.501 0.867 v 4.154 c 0 0.412 -0.253 0.782 -0.637 0.932 c -3.009 1.172 -4.954 4.012 -4.954 7.234 v 20.252 C 5.408 53.665 4.96 54.112 4.408 54.112 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 85.592 54.112 c -0.553 0 -1 -0.447 -1 -1 V 32.86 c 0 -3.222 -1.944 -6.062 -4.953 -7.234 c -0.384 -0.149 -0.637 -0.52 -0.637 -0.932 v -4.154 c 0 -0.358 0.191 -0.688 0.501 -0.867 c 0.963 -0.554 1.538 -1.535 1.538 -2.624 c 0 -1.677 -1.364 -3.041 -3.041 -3.041 s -3.041 1.364 -3.041 3.041 c 0 1.089 0.575 2.069 1.538 2.624 c 0.31 0.178 0.501 0.509 0.501 0.867 v 3.55 c 0 0.552 -0.447 1 -1 1 H 53.277 c -0.553 0 -1 -0.448 -1 -1 s 0.447 -1 1 -1 h 21.721 v -2.013 c -1.271 -0.946 -2.039 -2.441 -2.039 -4.028 c 0 -2.779 2.262 -5.041 5.041 -5.041 s 5.041 2.261 5.041 5.041 c 0 1.587 -0.769 3.082 -2.039 4.028 v 2.958 c 3.418 1.611 5.59 5.003 5.59 8.824 v 20.252 C 86.592 53.665 86.145 54.112 85.592 54.112 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                            </g>
                        </svg>
                         <p class="text-center" style ="color:#db3b3b"> <a href='{!!route("backend.$module_name.edit",$post->id)!!}'><i class="fas fa-edit"></i> @if(app()->getLocale()=='es') Agrega la imagen @else Add the image @endif </a></p>
    @endif
      <div class="card-body">
        <div class="card-title d-flex justify-content-between flex-row  flex-nowrap">
            <div class="text-capitalize">{{$post->name}}</div>
            <div class="text-capitalize">  @lang('labels.text.zone') : {{$post->zone}}</div>
            <div class="text-capitalize">  @lang('labels.text.rates') : {{$post->rates}}</div>
              <!-- <i class="fa fa-ellipsis-v"></i> -->
            <div class="">
                <div class="text-end">
                    <button onclick="threedot{{$post->id}}()" id="threedotbutton{{$post->id}}" class="border-0" style="background-color: none;">
                        <i class="fa fa-ellipsis-v"></i>
                    </button>
                </div>
                <div id="threedotdropdonwcontent{{$post->id}}" class="menu-card" tabindex="-1" style="display: none;position: absolute;z-index: 1; background-color:white;top: 287px;">
                <a href='{!!route("backend.$module_name.show",$post->id)!!}' class="text-secondary" style="text-decoration: none;">
                    <div><i class="fas fa-desktop"></i>@lang('labels.text.show')</div>
                </a>
                <a href='{!!route("backend.$module_name.edit",$post->id)!!}' class="text-secondary" style="text-decoration: none;">
                    <div><i class="fa fa-edit"></i> @lang('labels.backend.edit')</div>
                </a>
                <a href='{!!route("backend.$module_name.roomClone",$post->id)!!}' class="text-secondary" style="text-decoration: none;">
                    <div><i class="fa fa-copy"></i> @lang('labels.backend.clone')</div>
                </a>
                {{-- <form method="POST" action='{!!route("backend.$module_name.delete",$post->id)!!}'>
                    @csrf
                    @method('delete') --}}
                    <button type="submit" onclick='deleteRoom("{{$post->id}}")' class="btn btn-danger" style="border: none;background-color:white;color: grey;padding: 0px;"><div><i class="fas fa-trash-alt"></i> @lang('labels.backend.delete')</div></button>
                {{-- </form> --}}

                </div>

                <script type="text/javascript">
                    function threedot{{$post->id}}() {
                                    const x = document.getElementById("threedotdropdonwcontent{{$post->id}}");
                                    if (x.style.display === "none") {
                                        x.style.display = "block";
                                    } else {
                                        x.style.display = "none";
                                    }
                    }
                    document.addEventListener('mouseup', function(e) {
                                    var container = document.getElementById('threedotbutton{{$post->id}}');
                                    if (!container.contains(e.target)) {
                                        const x = document.getElementById("threedotdropdonwcontent{{$post->id}}");
                                        x.style.display = "none";
                                    }
                    });
                </script>



            </div>
        </div>
       
         <div class="text-capitalize"><i class="fas fa-map-marker-alt"></i>{{$post->town}}</div>   
         <div class="d-flex justify-content-between flex-row  flex-nowrap ">
             <div>
@php

  $slug=Illuminate\Support\Facades\DB::table('posts')->where('id',$post->id)->value('slug');

  if($slug == 0 || $slug == null || $slug == 'undefined'){
    $slug='empty';
  }

  $slugarr[$post->id]=$slug;


@endphp


        

<!-- Display the countdown timer in an element -->
                 <!-- <button  class="btn btn-danger btn-sm" id="clock{{$post->id}}"></button> -->

<script src = "https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.7.12/sweetalert2.min.js"></script>
 <script>

    function deleteRoom(id){
        Swal.fire({
            icon: 'question',
            title: 'Delete',
            text: 'Do you want to Delete?',
            iconColor: '#e80202',
            position: 'top', 
            width: 300,
            // showDenyButton: true,
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Delete',
            cancelButtonText: 'Cancel',
            }).then((result) => {
            /* Read more about isConfirmed, isDenied below */
            if (result.isConfirmed) { console.log(id);
                $.ajax({
                type: "POST",
                url: "{{route('backend.rooms.delete', )}}",
                data:{'_token':"{{csrf_token()}}", 
                        id: id},
                success:function(data) {
                    if(data == "success"){
                        window.location.reload();
                    }
                    else if(data == "error"){
                        window.location.reload();
                    }
                    // console.log(data);
                },
            })
            } 
            })
       
        
    }


    $(document).ready(function(){
       /*  $("#delete").click(function (e) { 
            e.preventDefault();
            var id = "<?php echo $post->id ?>";
            console.log(id);
            $.ajax({
                type: "DELETE",
                url
            })
        }); */

        
    })






setInterval(function(){

        $.ajax({
        type:'POST',
        data:{'_token':"{{csrf_token()}}"},
        url:'{{route("backend.$module_path.gettime",["slug"=> $slugarr[$post->id] ] )}}',
        success:function(data) {
            gettime{{$post->id}}(data);
        },
        error: function(data){
            console.log("error");
            // console.log(data);
        }
        });
 },1000);

function gettime{{$post->id}}(ad) {

        // console.log(ad);
        var finish{{$post->id}}=new Date();
        finish{{$post->id}}.setFullYear(ad.year,ad.month,ad.day);
        finish{{$post->id}}.setHours(ad.hour);
        finish{{$post->id}}.setMinutes(ad.minute);
        finish{{$post->id}}.setSeconds(ad.second);
        finish{{$post->id}}.toLocaleString('en',{timeZone: 'Europe/Madrid'});
        // console.log('finishtime',finish{{$post->id}});
        finish{{$post->id}}.getTime();

        var countDownDate{{$post->id}}=finish{{$post->id}};


        // Update the count down every 1 second
        var x{{$post->id}} = setInterval(function() {

          // Get today's date and time
          // var now = new Date( new Date().toLocaleString('en', {timeZone: 'Europe/Madrid'}) );
          // console.log('current data',now);
          var now{{$post->id}} = new Date( new Date().toLocaleString('en', {timeZone: 'Europe/Madrid'}) ).getTime();

          // Find the distance between now and the count down date
          var distance{{$post->id}} = countDownDate{{$post->id}} - now{{$post->id}};
          
          var time{{$post->id}} = distance{{$post->id}} / 1000;
          var day{{$post->id}} = Math.floor(time{{$post->id}} / (24*60*60));
          var checkfinishdate{{$post->id}}=day{{$post->id}};
          // console.log(checkfinishdate{{$post->id}});
          // Time calculations for days, hours, minutes and seconds
          var days{{$post->id}} = Math.floor(distance{{$post->id}} / (1000 * 60 * 60 * 24));
          var hours{{$post->id}} = Math.floor((distance{{$post->id}} % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
          var minutes{{$post->id}} = Math.floor((distance{{$post->id}} % (1000 * 60 * 60)) / (1000 * 60));
          var seconds{{$post->id}} = Math.floor((distance{{$post->id}} % (1000 * 60)) / 1000);

          // Display the result in the element with id="demo"
          if(document.getElementById("clocktimer{{$post->id}}")){

          document.getElementById("clocktimer{{$post->id}}").innerHTML =hours{{$post->id}}+':'+minutes{{$post->id}}+':'+ seconds{{$post->id}};
          }


          // if 30 day ad is running

              if(checkfinishdate{{$post->id}} < 1 && document.getElementById("inactiveclocktimer{{$post->id}}")){
                document.getElementById("inactiveclocktimer{{$post->id}}").innerHTML = `Expired`;    
              }else{
                    if(document.getElementById("inactiveclocktimer{{$post->id}}")){
                        document.getElementById("inactiveclocktimer{{$post->id}}").innerHTML =checkfinishdate{{$post->id}}+' days left'; 
                    }
              }

          
          
          if (distance{{$post->id}} < 0) {
            clearInterval(x{{$post->id}});
            if(document.getElementById("clocktimer{{$post->id}}")){
            document.getElementById("clocktimer{{$post->id}}").innerHTML = `Expired`;
            }    

    }
            }, 1000);
}

</script>
 
 

<!-- countdown clock end -->
             </div>
             
         </div>
      </div>
    </div>
  </div>
@endforeach



</div>

  @if(isset($data))
{!! $data->links() !!}
    @endif

  @endif

    <!--  end show all posts for admin -->

    </div>
    <div class="card-footer">
        <div class="row">
            <div class="col-7">
                <div class="float-left">

                </div>
            </div>
            <div class="col-5">
                <div class="float-end">
                   

                </div>
            </div>
        </div>
    </div>
</div>

@endsection



@push ('after-styles')
<!-- DataTables Core and Extensions -->
<link rel="stylesheet" href="{{ asset('vendor/datatable/datatables.min.css') }}">
<link
            href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css"
            rel="stylesheet"
            integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC"
            crossorigin="anonymous"
        />


@endpush

@push ('after-scripts')

 <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>


<!-- DataTables Core and Extensions -->
<script type="text/javascript" src="{{ asset('vendor/datatable/datatables.min.js') }}"></script>

@if($rolename == 'super admin')

<script type="text/javascript">

    $('#datatable').DataTable({
        processing: true,
        serverSide: true,
        autoWidth: true,
        responsive: true,
        ajax: '{{ route("backend.$module_name.index_data_room") }}',
        columns: [{
                data: 'id',
                name: 'id'
            },
            {
                data: 'name',
                name: 'name'
            },
            {
                data: 'town',
                name: 'town'
            },

            {
                data: 'rates',
                name: 'rates'
            },
            {
                data: 'updated_at',
                name: 'updated_at'
            },
            {
                data: 'action',
                name: 'action',
                orderable: false,
                searchable: false
            }
        ]
    });
</script>

@endif


@if($rolename == 'escort')



@endif
 
 


@endpush