@extends('backend.layouts.app')

@section('title') {{$module_action}} {{$module_title}} @endsection

@section('breadcrumbs')
<x-backend-breadcrumbs>
    <x-backend-breadcrumb-item route='{{route("backend.$module_name.index")}}' icon='{{ $module_icon }}'>
       {{$module_title}}
    </x-backend-breadcrumb-item>
    <x-backend-breadcrumb-item type="active">{{$module_action}}</x-backend-breadcrumb-item>
</x-backend-breadcrumbs>
@endsection

@section('content')



<style>
    a.thumbleft span.glyphicon-chevron-left::before {
        position: relative;
        top: 70px;
        z-index: 9;
    }
    a.thumbright span.glyphicon-chevron-right::before {
        top: -70px;
        position: relative;
        z-index: 9;
    }
    .change-thumbnail {
       box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important; 
}
.change-thumbnail:hover,.change-thumbnail:focus,.change-thumbnail:visited{
    box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important; 
}
.change-thumbnail:active{
   box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important;   
}
</style>
<div class="card">
    <div class="card-body">

        <x-backend.section-header>
            <i class="{{ $module_icon }}"></i>{{$module_title}} <small class="text-muted">{{$module_action}}</small>

            <!-- <x-slot name="subtitle">
               {{-- @lang(":module_name Management Dashboard", ['module_name'=>Str::title($module_name)])--}}
                @lang('labels.text.management_dashboard')
            </x-slot> -->
            <x-slot name="toolbar">
                <button onclick="window.history.back();" class="btn change-thumbnail ms-1 " data-toggle="tooltip" aria-label="Return Back" data-coreui-original-title="@lang('labels.text.return_back')"><i class="fas fa-reply"></i>&nbsp;</button>

                <a href='{{ route("backend.$module_name.index") }}' class="btn change-thumbnail " data-toggle="tooltip" title=" @lang('labels.text.list')"><i class="fas fa-list"></i>  @lang('labels.text.list')</a>
                @can('edit_'.$module_name)
                   
                <x-buttons.edit route='{!!route("backend.$module_name.edit",$$module_name_singular->id)!!}' 
                    title="{{ __('labels.backend.edit_post') }}" class="ms-1 change-thumbnail bg-light" />
                   
                @endcan
            </x-slot>
        </x-backend.section-header>

        <hr>

        <div class="row">
            <div class="col-6">
            @if($thumbnailname !=null)
            <div class="d-flex justify-content-center">
                <div class="col-md-3 border-right">
                    <div class="d-flex flex-column align-items-center text-center p-3">
                        <img class="rounded-circle" width="150px" src="{{ asset($thumbnailPath)}}/{{$thumbnail}}">
                    </div>
                </div>
            </div>
            @endif
            </div>
            <div class="col-6 text-secondary">
                    <h4>@lang('labels.text.account_info')</h4>
                <div class="row row-cols-1">
                    <p>@lang('labels.text.name') :{{$userDetails->name}}</p>
                    <p>@lang('labels.text.email') :{{$userDetails->email}}</p>
                    <p>@lang('labels.text.credits') :{{$userDetails->credits}}</p>
                    @if($userDetails->mobile !=null)
                    <p>@lang('labels.text.phone') :
                        @if($userDetails->mobile_verified_at !=null)
                        {{$userDetails->mobile}}
                        (Verified)
                        @else
                        <a href="{{route('frontend.users.verifyphone')}}">{{$userDetails->mobile}}(UnVerified)</a>
                        @endif
                        
                    </p>
                    @endif
                </div>
            </div>
        </div>
<!-- <a href="tg://msg?text=Hai&to=">telegram</a> -->

        <div class="row">
            <div class="col-12 col-sm-6">

                @include('backend.includes.show')

            </div>
            <div class="col-12 col-sm-6">
            
            <div class="" style="width:90%;">
                <hr class="mt-0">
                <div class="col-sm-12 row">
                    @if($imageFile !=null)

                        @php
                        $imageArr=[null,null,null,null,null];
                        $totalImages=count($imageFile);
                        foreach($imageFile as $index => $image){
                            $imageArr[$index]=$image;
                        }
                        
                        @endphp    


                         <div id="carouselExampleControls" class="carousel slide" data-bs-ride="carousel">
                          <div class="carousel-inner" style="height: 100%;">
                                @if($imageArr[0])
                            <div class="carousel-item active">
                              <img class="d-block w-100" src="{{asset($imagePath)}}/{{$imageArr[0]}}" alt="First slide">
                            </div>
                                @endif
                                @if($imageArr[1])
                            <div class="carousel-item">
                              <img class="d-block w-100" src="{{asset($imagePath)}}/{{$imageArr[1]}}" alt="Second Slide">
                            </div>
                                @endif
                                 @if($imageArr[2])
                            <div class="carousel-item">
                               <img class="d-block w-100" src="{{asset($imagePath)}}/{{$imageArr[2]}}" alt="Third Slide">
                            </div>
                                @endif
                                @if($imageArr[3])
                            <div class="carousel-item">
                               <img class="d-block w-100" src="{{asset($imagePath)}}/{{$imageArr[3]}}" alt="Fourth Slide">
                            </div>
                            @endif
                                 @if($imageArr[4])
                            <div class="carousel-item">
                               <img class="d-block w-100" src="{{asset($imagePath)}}/{{$imageArr[4]}}" alt="Fivth Slide">
                            </div>
                                @endif
                          </div>
                          <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="sr-only">Previous</span>
                          </a>
                          <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-bs-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="sr-only">Next</span>
                          </a>
                        </div>



                    @endif
                </div>   

                {{-- <h4>Category</h4> --}}
                {{-- <ul>
                    <li>
                        <a href="{{route('backend.categories.show', $$module_name_singular->category_id)}}">{{$$module_name_singular->category_name}}</a>
                    </li>
                </ul> --}}
                {{-- <hr> --}}

                {{-- <h4>Tags</h4>
                <ul>
                    @foreach($$module_name_singular->tags as $row)
                    <li>
                        <a href="{{route('backend.tags.show', $row->id)}}">{{$row->name}}</a>
                    </li>
                    @endforeach
                </ul>
                <hr>

                <h4>Comments</h4>
                <ul>
                    @foreach($$module_name_singular->comments as $row)
                    <li>
                        <a href="{{route('backend.comments.show', $row->id)}}">{{$row->name}}</a> by {{$row->user_name}}
                    </li>
                    @endforeach
                </ul>
                <hr> --}}

                {{-- @include('article::backend.includes.activitylog') --}}
                {{-- <hr> --}}

            </div>
        </div>
    </div>

    <div class="card-footer">
        <div class="row">
            <div class="col">
                <small class="float-end text-muted">
              @lang('labels.backend.users.fields.updated_at'): {{$$module_name_singular->updated_at->diffForHumans()}},
                    @lang('labels.backend.users.fields.created_at'): {{$$module_name_singular->created_at->isoFormat('LLLL')}}
                </small>
            </div>
        </div>
    </div>
</div>



@endsection

