@extends('backend.layouts.app')

@section('title') {{ __($module_action) }} {{ __($module_title) }} @endsection

@section('breadcrumbs')
<x-backend-breadcrumbs>
    <x-backend-breadcrumb-item route='{{route("backend.room.index")}}' icon='{{ $module_icon }}'>
        {{ __($module_title) }}
    </x-backend-breadcrumb-item>
    <x-backend-breadcrumb-item type="active">{{ __($module_action) }}</x-backend-breadcrumb-item>
</x-backend-breadcrumbs>
@endsection

@section('content')



<style>
    a.thumbleft span.glyphicon-chevron-left::before {
        position: relative;
        top: 70px;
        z-index: 9;
    }
    a.thumbright span.glyphicon-chevron-right::before {
        top: -70px;
        position: relative;
        z-index: 9;
    }
    .change-thumbnail {
       box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important; 
}
.change-thumbnail:hover,.change-thumbnail:focus,.change-thumbnail:visited{
    box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important; 
}
.change-thumbnail:active{
   box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important;   
}
</style>
<div class="card">
    <div class="card-body">

        <x-backend.section-header>
            <i class="{{ $module_icon }}"></i> {{ __($module_title) }} <small class="text-muted">{{ __($module_action) }}</small>

            <!-- <x-slot name="subtitle">
                @lang(":module_name Management Dashboard", ['module_name'=>Str::title($module_name)])
            </x-slot> -->
            <x-slot name="toolbar">
                <button onclick="window.history.back();" class="btn change-thumbnail ms-1 " data-toggle="tooltip" aria-label="Return Back" data-coreui-original-title="Return Back"><i class="fas fa-reply"></i>&nbsp;</button>

                <a href='{{ route("backend.room.index") }}' class="btn change-thumbnail " data-toggle="tooltip" title="{{ ucwords($module_name) }} List"><i class="fas fa-list"></i> List</a>
                {{-- @can('edit_'.$module_name) --}}
                   
                <x-buttons.edit route='{!!route("backend.$module_name.edit",$data->id)!!}' title="{{__('Edit')}} {{ ucwords(Str::singular($module_name)) }}" class="ms-1 change-thumbnail bg-light" />
                   
                {{-- @endcan --}}
            </x-slot>
        </x-backend.section-header>

        <hr>

        <div class="row">
            <div class="col-6">
                <?php //print_r($imageFile[0]); ?>
            {{-- @if($thumbnailname !=null) --}}
            <div class="d-flex justify-content-center">
                <div class="col-md-12 border-right">
                    <div class="d-flex flex-column align-items-center text-center p-3">
                    @if (isset($imageFile[0]))
                        <img class="" width="100%" src="{{URL::to('/');}}/public/images/userimage/{{$module_name}}/{{$data->id}}/{{$imageFile[0]}}">
                    @else
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="256" height="256" viewBox="0 0 256 256" xml:space="preserve">
                            <defs>
                            </defs>
                            <g style="stroke: none; stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: none; fill-rule: nonzero; opacity: 1;" transform="translate(1.4065934065934016 1.4065934065934016) scale(2.81 2.81)">
                                <path d="M 89 80.376 H 1 V 60.401 c 0 -5.25 4.256 -9.505 9.505 -9.505 h 68.99 c 5.25 0 9.505 4.256 9.505 9.505 V 80.376 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(239,237,239); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 83.13 86.246 h -1.337 c -3.242 0 -5.87 -2.628 -5.87 -5.87 l 0 0 H 89 l 0 0 C 89 83.618 86.372 86.246 83.13 86.246 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(185,185,185); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 85.592 53.112 V 32.86 c 0 -3.72 -2.321 -6.892 -5.59 -8.166 v -4.154 c 1.213 -0.697 2.039 -1.991 2.039 -3.49 c 0 -2.232 -1.809 -4.041 -4.041 -4.041 s -4.041 1.809 -4.041 4.041 c 0 1.499 0.826 2.793 2.039 3.49 v 3.55 h -22.72 H 36.573 H 14.002 v -3.55 c 1.213 -0.697 2.039 -1.991 2.039 -3.49 c 0 -2.232 -1.809 -4.041 -4.041 -4.041 s -4.041 1.809 -4.041 4.041 c 0 1.499 0.826 2.793 2.039 3.49 v 4.154 c -3.27 1.274 -5.59 4.445 -5.59 8.166 v 20.252 H 85.592 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(239,237,239); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 57.749 6.337 c -2.941 -3.322 -8.511 -3.734 -12.824 0.508 c -4.313 -4.242 -9.883 -3.83 -12.824 -0.508 c -3.128 3.534 -1.814 10.13 2.304 15.402 c 2.087 2.672 7.244 7.023 10.52 8.85 c 3.275 -1.827 8.432 -6.179 10.52 -8.85 C 59.564 16.467 60.878 9.871 57.749 6.337 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(254,147,211); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 8.208 86.246 H 6.87 c -3.242 0 -5.87 -2.628 -5.87 -5.87 l 0 0 h 13.078 l 0 0 C 14.078 83.618 11.45 86.246 8.208 86.246 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(185,185,185); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 89 63.863 H 1 c 0 0 0 -3.462 0 -3.462 c 0 -5.25 4.256 -9.505 9.505 -9.505 h 68.99 c 5.25 0 9.505 4.256 9.505 9.505 C 89 60.401 89 63.863 89 63.863 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(254,254,254); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 42.417 50.826 H 14.078 v 0 c 0 -6.435 5.217 -11.652 11.652 -11.652 h 5.036 C 37.2 39.174 42.417 44.391 42.417 50.826 L 42.417 50.826 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(254,254,254); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 75.922 50.826 H 47.583 v 0 c 0 -6.435 5.217 -11.652 11.652 -11.652 h 5.036 C 70.705 39.174 75.922 44.391 75.922 50.826 L 75.922 50.826 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(254,254,254); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 44.925 31.589 c -0.168 0 -0.336 -0.042 -0.487 -0.126 c -3.375 -1.883 -8.634 -6.31 -10.82 -9.108 c -4.626 -5.922 -5.579 -12.937 -2.265 -16.68 c 1.589 -1.794 3.819 -2.83 6.28 -2.915 c 2.568 -0.102 5.121 0.875 7.293 2.729 c 2.171 -1.854 4.728 -2.832 7.293 -2.729 c 2.461 0.085 4.691 1.12 6.279 2.915 c 3.313 3.743 2.361 10.758 -2.265 16.68 c -2.188 2.799 -7.446 7.226 -10.821 9.108 C 45.261 31.547 45.093 31.589 44.925 31.589 z M 37.956 4.754 c -0.085 0 -0.169 0.001 -0.254 0.004 C 35.794 4.824 34.071 5.62 32.85 7 c -2.631 2.973 -1.624 9.045 2.344 14.124 c 1.919 2.457 6.581 6.419 9.731 8.31 c 3.15 -1.89 7.812 -5.853 9.732 -8.31 C 58.625 16.044 59.632 9.972 57 7 c 0 0 0 0 0 0 c -1.221 -1.379 -2.943 -2.175 -4.851 -2.241 c -2.288 -0.079 -4.606 0.916 -6.523 2.799 c -0.389 0.383 -1.014 0.383 -1.402 0 C 42.379 5.743 40.163 4.754 37.956 4.754 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 35.351 14.601 c -0.424 0 -0.818 -0.273 -0.953 -0.699 c -0.611 -1.935 -0.371 -3.71 0.658 -4.873 c 1.12 -1.265 2.873 -1.745 4.575 -1.25 c 0.53 0.154 0.835 0.709 0.682 1.239 c -0.154 0.53 -0.708 0.834 -1.239 0.682 c -0.951 -0.277 -1.918 -0.025 -2.521 0.655 c -0.552 0.624 -0.642 1.697 -0.248 2.944 c 0.167 0.527 -0.126 1.088 -0.652 1.255 C 35.553 14.586 35.451 14.601 35.351 14.601 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 89 81.376 H 1 c -0.552 0 -1 -0.447 -1 -1 V 60.4 c 0 -5.792 4.713 -10.505 10.505 -10.505 h 68.99 C 85.287 49.896 90 54.608 90 60.4 v 19.976 C 90 80.929 89.553 81.376 89 81.376 z M 2 79.376 h 86 V 60.4 c 0 -4.689 -3.815 -8.505 -8.505 -8.505 h -68.99 C 5.815 51.896 2 55.711 2 60.4 V 79.376 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 42.417 51.826 H 14.078 c -0.552 0 -1 -0.447 -1 -1 c 0 -6.976 5.675 -12.652 12.651 -12.652 h 5.036 c 6.976 0 12.651 5.676 12.651 12.652 C 43.417 51.379 42.969 51.826 42.417 51.826 z M 15.125 49.826 h 26.246 c -0.506 -5.406 -5.069 -9.652 -10.605 -9.652 h -5.036 C 20.194 40.174 15.63 44.42 15.125 49.826 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 75.922 51.826 H 47.583 c -0.553 0 -1 -0.447 -1 -1 c 0 -6.976 5.676 -12.652 12.651 -12.652 h 5.036 c 6.976 0 12.651 5.676 12.651 12.652 C 76.922 51.379 76.475 51.826 75.922 51.826 z M 48.63 49.826 h 26.245 c -0.506 -5.406 -5.068 -9.652 -10.604 -9.652 h -5.036 C 53.698 40.174 49.136 44.42 48.63 49.826 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 89 64.862 H 1 c -0.552 0 -1 -0.447 -1 -1 s 0.448 -1 1 -1 h 88 c 0.553 0 1 0.447 1 1 S 89.553 64.862 89 64.862 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 8.208 87.246 H 6.871 C 3.082 87.246 0 84.164 0 80.376 c 0 -0.553 0.448 -1 1 -1 h 13.078 c 0.552 0 1 0.447 1 1 C 15.078 84.164 11.996 87.246 8.208 87.246 z M 2.103 81.376 c 0.463 2.207 2.425 3.87 4.768 3.87 h 1.337 c 2.343 0 4.305 -1.663 4.768 -3.87 H 2.103 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 83.13 87.246 h -1.338 c -3.788 0 -6.87 -3.082 -6.87 -6.87 c 0 -0.553 0.447 -1 1 -1 H 89 c 0.553 0 1 0.447 1 1 C 90 84.164 86.918 87.246 83.13 87.246 z M 77.025 81.376 c 0.462 2.207 2.424 3.87 4.767 3.87 h 1.338 c 2.343 0 4.305 -1.663 4.767 -3.87 H 77.025 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 4.408 54.112 c -0.552 0 -1 -0.447 -1 -1 V 32.86 c 0 -3.82 2.172 -7.212 5.59 -8.824 v -2.958 c -1.27 -0.946 -2.039 -2.441 -2.039 -4.028 c 0 -2.779 2.261 -5.041 5.041 -5.041 s 5.041 2.261 5.041 5.041 c 0 1.587 -0.769 3.082 -2.039 4.028 v 2.013 h 21.571 c 0.552 0 1 0.448 1 1 s -0.448 1 -1 1 H 14.002 c -0.552 0 -1 -0.448 -1 -1 v -3.55 c 0 -0.358 0.191 -0.688 0.501 -0.867 c 0.962 -0.554 1.537 -1.535 1.537 -2.624 c 0 -1.677 -1.364 -3.041 -3.041 -3.041 s -3.041 1.364 -3.041 3.041 c 0 1.089 0.575 2.07 1.537 2.624 c 0.31 0.178 0.501 0.509 0.501 0.867 v 4.154 c 0 0.412 -0.253 0.782 -0.637 0.932 c -3.009 1.172 -4.954 4.012 -4.954 7.234 v 20.252 C 5.408 53.665 4.96 54.112 4.408 54.112 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                                <path d="M 85.592 54.112 c -0.553 0 -1 -0.447 -1 -1 V 32.86 c 0 -3.222 -1.944 -6.062 -4.953 -7.234 c -0.384 -0.149 -0.637 -0.52 -0.637 -0.932 v -4.154 c 0 -0.358 0.191 -0.688 0.501 -0.867 c 0.963 -0.554 1.538 -1.535 1.538 -2.624 c 0 -1.677 -1.364 -3.041 -3.041 -3.041 s -3.041 1.364 -3.041 3.041 c 0 1.089 0.575 2.069 1.538 2.624 c 0.31 0.178 0.501 0.509 0.501 0.867 v 3.55 c 0 0.552 -0.447 1 -1 1 H 53.277 c -0.553 0 -1 -0.448 -1 -1 s 0.447 -1 1 -1 h 21.721 v -2.013 c -1.271 -0.946 -2.039 -2.441 -2.039 -4.028 c 0 -2.779 2.262 -5.041 5.041 -5.041 s 5.041 2.261 5.041 5.041 c 0 1.587 -0.769 3.082 -2.039 4.028 v 2.958 c 3.418 1.611 5.59 5.003 5.59 8.824 v 20.252 C 86.592 53.665 86.145 54.112 85.592 54.112 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(63,63,63); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                            </g>
                        </svg>
                        <p class="text-center" style ="color:#db3b3b">Add the image</p>
                    @endif
                    </div>
                </div>
            </div>
            {{-- @endif --}}
            </div>
            <div class="col-6 text-secondary">
                    <h4>Account(info)</h4>
                <div class="row row-cols-1">
                    <p>NAME: {{$userDetails->name}}</p>
                    <p>EMAIL: {{$userDetails->email}}</p>
                    <p>CREDITS: {{$userDetails->credits}}</p>
                    @if($userDetails->mobile !=null)
                    <p>PHONE: 
                        @if($userDetails->mobile_verified_at !=null)
                        {{$userDetails->mobile}}
                        (Verified)
                        @else
                        <a href="{{route('frontend.users.verifyphone')}}">{{$userDetails->mobile}}(UnVerified)</a>
                        @endif
                        
                    </p>
                    @endif
                </div>
            </div>
        </div>
<!-- <a href="tg://msg?text=Hai&to=">telegram</a> -->

        <div class="row">
            <div class="col-12 col-sm-6">

                <table class="table table-responsive-sm table-hover table-bordered" style="color:grey;text-transform: capitalize;">
                    <?php
                    $all_columns = $data->getTableColumns();
                    ?>
                    <thead>
                    <tr>
                        <th scope="col">
                            <strong>@lang('Title')</strong></th>
                        <th scope="col">
                            <strong>@lang('Content')</strong></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><strong>Title</strong></td>
                        <td>{{$data->name}}</td>
                    </tr>
                    <tr>
                        <td><strong>City</strong></td>
                        <td>{{$data->town}}</td>
                    </tr>
                    <tr>
                        <td><strong>Zone</strong></td>
                        <td>{{$data->zone}}</td>
                    </tr>
                    <tr>
                        <td><strong>Phone</strong></td>
                        <td>
                            {{$data->phone}}
                            @if($userDetails->mobile_verified_at !=null)
                                (Verified)
                            @else
                                (UnVerified)
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Price(€)</strong></td>
                        <td>{{$data->rates}}</td>
                    </tr>
                    <tr>
                        <td><strong>Whatsapp Consent</strong></td>
                        <td>{{$data->whatsapp}}</td>
                    </tr>
                
                    {{-- <tr>
                        <td><strong>Payment Types</strong></td>
                        <td>
                         @foreach($data->paymenttypes as $types)
                            @if($loop->last)
                           {{$types}}
                            @else
                           {{$types}} |
                            @endif
                         @endforeach
                        </td>
                    </tr> --}}
                    
                
                    {{-- <tr>
                        <td><strong>Metting Place</strong></td>
                        <td>
                            @foreach($data->metting_place as $place)
                             @if($loop->last)
                           {{$place}}
                            @else
                           {{$place}} |
                            @endif
                            @endforeach
                        </td>
                    </tr> --}}
                
                
                    <tr>
                        <td><strong>Message</strong></td>
                        <td>{{$data->text_content}}</td>
                    </tr>
                
                
                
                </tbody>
                </table>
                
                {{-- Lightbox2 Library --}}
                <x-library.lightbox />

            </div>
            <div class="col-12 col-sm-6">
            
            <div class="" style="width:90%;">
                <hr class="mt-0">
                <div class="col-sm-12 row">
                    @if($imageFile !=null)

                        @php
                        $imageArr=[null,null,null,null,null];
                        $totalImages=count($imageFile);
                        foreach($imageFile as $index => $image){
                            $imageArr[$index]=$image;
                        }
                        
                        @endphp    


                         <div id="carouselExampleControls" class="carousel slide" data-bs-ride="carousel">
                          <div class="carousel-inner" style="height: 100%;">
                                @if(isset($imageFile[0]))
                            <div class="carousel-item active">
                              <img class="d-block w-100" src="{{URL::to('/');}}/public/images/userimage/{{$module_name}}/{{$data->id}}/{{$imageFile[0]}}" alt="First slide">
                            </div>
                                @endif
                                @if(isset($imageFile[1]))
                            <div class="carousel-item">
                              <img class="d-block w-100" src="{{URL::to('/');}}/public/images/userimage/{{$module_name}}/{{$data->id}}/{{$imageFile[1]}}" alt="Second Slide">
                            </div>
                                @endif
                                 @if(isset($imageFile[2]))
                            <div class="carousel-item">
                               <img class="d-block w-100" src="{{URL::to('/');}}/public/images/userimage/{{$module_name}}/{{$data->id}}/{{$imageFile[2]}}" alt="Third Slide">
                            </div>
                                @endif
                                @if(isset($imageFile[3]))
                            <div class="carousel-item">
                               <img class="d-block w-100" src="{{URL::to('/');}}/public/images/userimage/{{$module_name}}/{{$data->id}}/{{$imageFile[3]}}" alt="Fourth Slide">
                            </div>
                            @endif
                                 @if(isset($imageFile[4]))
                            <div class="carousel-item">
                               <img class="d-block w-100" src="{{URL::to('/');}}/public/images/userimage/{{$module_name}}/{{$data->id}}/{{$imageFile[4]}}" alt="Fivth Slide">
                            </div>
                                @endif
                          </div>
                          <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="sr-only">Previous</span>
                          </a>
                          <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-bs-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="sr-only">Next</span>
                          </a>
                        </div>



                    @endif
                </div>   

                {{-- <h4>Category</h4> --}}
                {{-- <ul>
                    <li>
                        <a href="{{route('backend.categories.show', $data->category_id)}}">{{$data->category_name}}</a>
                    </li>
                </ul> --}}
                {{-- <hr> --}}

                {{-- <h4>Tags</h4>
                <ul>
                    @foreach($data->tags as $row)
                    <li>
                        <a href="{{route('backend.tags.show', $row->id)}}">{{$row->name}}</a>
                    </li>
                    @endforeach
                </ul>
                <hr>

                <h4>Comments</h4>
                <ul>
                    @foreach($data->comments as $row)
                    <li>
                        <a href="{{route('backend.comments.show', $row->id)}}">{{$row->name}}</a> by {{$row->user_name}}
                    </li>
                    @endforeach
                </ul>
                <hr> --}}

                {{-- @include('article::backend.includes.activitylog') --}}
                {{-- <hr> --}}

            </div>
        </div>
    </div>

    <div class="card-footer">
        <div class="row">
            <div class="col">
                <small class="float-end text-muted">
                    Updated: {{$data->updated_at->diffForHumans()}},
                    Created at: {{$data->created_at->isoFormat('LLLL')}}
                </small>
            </div>
        </div>
    </div>
</div>



@endsection

