
@extends('backend.layouts.app')

@section('title'){{$module_action}} {{$module_title}} @endsection

@section('breadcrumbs')
<x-backend-breadcrumbs>
    <x-backend-breadcrumb-item route='{{route("backend.room.index")}}' icon='{{ $module_icon }}'>
       {{$module_title}}
    </x-backend-breadcrumb-item>
    <x-backend-breadcrumb-item type="active">{{$module_action}}</x-backend-breadcrumb-item>
</x-backend-breadcrumbs>
@endsection

@section('content')


<style type="text/css">
    .form-control:focus {
    background-color: #fff;
    border-color: #f700f0;
     box-shadow:unset; 
}
.select2-container--bootstrap .select2-results__option--highlighted[aria-selected] {
    background-color: #f800f2;
}
.select2-container--bootstrap.select2-container--focus .select2-selection, .select2-container--bootstrap.select2-container--open .select2-selection {
    border-color: #f800f2;
}
.select2-container--bootstrap .select2-dropdown {
    border-color: #f800f2;
}

.text-danger {
    display: none;
}

.form-group {
    padding: 0px;
    padding-bottom: 1rem;
}
.change-thumbnail {
       box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important; 
}
.change-thumbnail:hover,.change-thumbnail:focus,.change-thumbnail:visited{
    box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important; 
}
.change-thumbnail:active{
   box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important;   
}
.input-thumbnail {
        opacity: 0;
        position: absolute;
        display: inline-block;
        width: 149px;
        padding: 0px;
        margin: -4px;
        margin-left: -37px;
        cursor: pointer;
}
span.select2.select2-container.select2-container--bootstrap{
    width: auto !important;
}
label,.form-check-label {
    color: grey;
}

.form-check-input{
    background-color: white;
}
.form-check-input:focus {
    background-color: #ffffff;
    border-color: #80808096;
    box-shadow: none;
}
.form-check-input:checked{
    background-color: #f800f2;
    border-color: #f800f2;
    box-shadow: none;
}

/*pop over show action icon*/
 /*on hover image pop up button*/
  .popup-container {
  position: relative;
  /*width: 50%;*/
}

.popup-image {
  opacity: 1;
  display: block;
  width: 100%;
  height: auto;
  transition: .5s ease;
  backface-visibility: hidden;
}

.popup-middle {
  transition: .5s ease;
  opacity: 0;
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  -ms-transform: translate(-50%, -50%);
  text-align: center;
}

.popup-container:hover .popup-image {
  opacity: 0.3;
}

.popup-container:hover .popup-middle {
  opacity: 1;
}

.popup-text {
  /*background-color:#f800f2;*/
  color: white;
  font-size: 16px;
  padding: 16px 32px;
}
.popup-text> i {
    padding: 4px;
}
.popup-container:hover .popup-image {
    opacity: 0.6;
    box-shadow: 0px 0px 9px #f800f2;
}

.upload-new-image{
    display: inline-block;
    width: 40%;
    margin: 4px;
}
.upload-new-image:visited{
    background: green;
}

</style>




<div class="card">
    <div class="card-body">
        <x-backend.section-header>
            <i class="{{ $module_icon }}"></i>{{$module_title}} <small class="text-muted"> {{$module_action}}</small>

            <x-slot name="subtitle">@lang('labels.text.management_dashboard')
                {{--@lang("$module_name Management Dashboard", ['module_name'=>Str::title($module_name)])--}}
                {{--gt::trans($module_title.' Management Dashboard',app()->getLocale())--}}
            </x-slot>
            <x-slot name="toolbar">
                
                <button onclick="window.history.back();" class="btn change-thumbnail ms-1 " data-toggle="tooltip" aria-label="Return Back" data-coreui-original-title="@lang('labels.text.return_back') "><i class="fas fa-reply"></i>&nbsp;</button>

                     <a href='{!!route("backend.$module_name.show",$data->id)!!}' class="btn change-thumbnail ms-1" data-toggle="tooltip" title="@lang('labels.text.show')  {{ ucwords(Str::singular($module_name)) }}"><i class="fas fa-desktop"></i></a>

            </x-slot>
        </x-backend.section-header>

<!--  auto renew option -->


</div> 

        <hr>

        <div class="row mt-4">
            <div class="col">


<!-- Add new image modal start -->

<!-- Modal -->
<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <form action="{{route('backend.rooms.room_add_image',['id'=>$data->id])}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">
                        <button type="button" onclick="add();" class="btn change-thumbnail"><i
                                class="fa fa-plus-circle"></i></button>
                        <button type="button" onclick="remove();" class="btn change-thumbnail"><i
                                class="fa fa-minus-circle"></i></button>
                    </h5>
                    <!-- <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"> -->
                    <!-- <span aria-hidden="true">&times;</span> -->
                    </button>
                </div>
                <div class="modal-body">
                    <!-- <button class="btn change-thumbnail upload-new-image" type="button" id="parent1">
              <i class="fa fa-fw fa-camera"></i><input type="file" name="addimage1" class="input-thumbnail" onchange="changecolor.call(this,'parent1');"><span>Upload Photo</span>
              </button> -->
                    <div id="new_chq" style="display: flex;flex-direction: column;"></div>
                    <input type="hidden" value="1" id="total_chq">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn change-thumbnail" data-bs-dismiss="modal"> @lang('labels.buttons.general.close')</button>
                    <button type="submit" class="btn change-thumbnail"> @lang('labels.buttons.general.upload')</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add new image modal end -->



<form method="Post" action='{{route("backend.$module_name.update",$data->id)}}' class="form" enctype="multipart/form-data">
    @csrf
    @method('PATCH')



    {{-- <div class="d-flex justify-content-center">
        <div class="col-md-3 border-right">
            <div class="d-flex flex-column align-items-center text-center p-3">
                <img class="rounded-circle" width="150px" id="preview"
                    src="{{ asset($thumbnailPath) }}/{{ $thumbnail }}">
                <div class="mt-2 text-center">
                    <button class="btn change-thumbnail " type="button" id="thumbnailimage-image">
                        <i class="fa fa-fw fa-camera" id="check-icon"></i>
                        <!-- <i class="fa-solid fa-check"></i> -->
                        <input type="file" name="thumbnailimage" class="input-thumbnail" accept="image/*"
                            onchange="changecolor.call(this,'thumbnailimage-image','check-icon');loadFile(event);">
                        <span>@lang('labels.buttons.change_photo')</span>
                    </button>
                </div>
            </div>
        </div>
    </div> --}}
    <div class="row m-1">
        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
            <div class="form-group">

                <?php
                $field_name = 'name';
                $field_lable =trans('labels.text.title');
                $field_placeholder = $field_lable;
                $required = 'required';
                ?>
                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                {{ html()->text($field_name)->value($data->name)->placeholder($field_placeholder)->class('form-control')->attributes(["$required"]) }}
            </div>
        </div>


        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
            <div class="form-group text-capitalize">
                <?php
                $field_name = 'town';
                $field_lable =trans('labels.text.town');
                $field_placeholder = $field_lable ;
                $required = 'required';
                $select_options = [];
                foreach ($cities as $cityobj) {
                    $select_options[$cityobj->city] = $cityobj->city;
                }
                ?>
                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                {{ html()->select($field_name, $select_options)->value($data->town)->placeholder($field_placeholder)->class('form-control select2')->attributes(["$required"]) }}
            </div>
        </div>

        


        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
            <div class="form-group">
                <?php
                $field_name = 'zone';
                $field_lable = trans('labels.text.zone');
                $field_placeholder = $field_lable ;
                $required = 'required';
                ?>
                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                {{ html()->text($field_name)->value($data->zone)->placeholder($field_placeholder)->class('form-control')->attributes(["$required"]) }}
            </div>
        </div>

        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
            <div class="form-group ">
                <?php
                $field_name = 'rates';
                $field_lable =trans('labels.text.rates');
                $field_placeholder = $field_lable ;
                $required = 'required';
                
                ?>
                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                {{ html()->number($field_name)->value($data->rates)->placeholder($field_placeholder)->class('form-control select2')->attributes(["$required"]) }}
            </div>
        </div>


        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
            <div class="form-group">
                <?php
                $field_name = 'phone';
                $field_lable =trans('labels.text.phone');
                $field_placeholder = $field_lable;
                $required = 'required';
                ?>
                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                {{ html()->text($field_name)->value($mobile)->placeholder($field_placeholder)->class('form-control')->attributes(["$required readonly"]) }}
            </div>
        </div>
       


        

        

        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
            <div class="form-group">
                <?php
                $field_name = 'whatsapp';
                $field_lable = trans('labels.text.whatsapp');
                $field_placeholder = $field_lable;
                $required = 'required';
                $select_options = [
                    'yes' => 'Yes',
                    'no' => 'No',
                ];
                ?>
                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                {{ html()->select($field_name, $select_options)->value($data->whatsapp)->placeholder($field_placeholder)->class('form-control select2')->attributes(["$required"]) }}
            </div>
        </div>
        

      

        

    <div class="col-12">
        <div class="p-1">
            <div class="form-group">
                <label for="text_content">@lang('labels.text.Message')</label>
                <textarea class="form-control" required id="text_content" name="text_content" rows="4" maxlength="500" required>{{ $data->text_content }}</textarea>
            </div>
        </div>
        <!--<div class="p-1 pt-4"> -->
        <!--    <p  style="background: #fa00f575;color: white;border-radius: 5px;padding: 8px;font-size: smaller;">-->
        <!--        On this website, we take the respect and integrity of all our users very seriously. Therefore, we want to make it clear that the use of words with SEXUAL content or any other type of inappropriate language is strictly prohibited.We reserve the right to ban any user who violates this rule. We expect all of our users to behave responsibly and respectfully in order to maintain a safe and enjoyable environment for all.Thank you for your understanding and cooperation in this matter.-->
        <!--    </p>                        -->
        <!--</div>-->
    </div>

    </div>


    <div class="d-flex justify-content-center">
        <div class="">
            {{ html()->submit($text = icon('fas fa-save') .@trans('labels.backend.save'))->class('btn change-thumbnail') }}
        </div>
    </div>

    <div></div>

</form>


<div class="row mt-3">


    <div class="col-12">
        <!-- <label class="mt-2">Add Images</label>  -->
        @php
            $total_images = 0;
            if ($data->imageFile) {
                if (count($data->imageFile)) {
                    $total_images = count($data->imageFile);
                }
            }
        @endphp
        @if ($total_images == 5)
            <!--  hide the Add image button -->
        @else
            <h3 class="">
                <!-- Button trigger add new image modal -->
                <button type="button" class="btn change-thumbnail" data-bs-toggle="modal"
                    data-bs-target="#exampleModalCenter">@lang('labels.backend.users.fields.add_images')
                </button>
            </h3>
        @endif
        <!-- <div class="modal-title" id="form-area">
               <button type="button" onclick="add();" class="btn update-btn change-thumbnail">ADD <i class="fa fa-plus-circle"></i></button>
               <button type="button" onclick="remove();" class="btn update-btn change-thumbnail">Remove <i class="fa fa-minus-circle"></i></button>
          </div>
          <div class="modal-body" style="display: flex;justify-content: center;">
              <div id="new_chq" ></div>
              <input type="hidden" value="1" id="total_chq">
        </div> -->

    </div>


    <div class="col-12">

        @if (isset($data->imageFile))

            @if (!empty($data->imageFile))
                <label class="mt-2">@lang('labels.backend.users.fields.edit_images')</label>
                <div class="" id="">
                    @php
                        $totalImage = count($data->imageFile);
                        $remaining = 5 - $totalImage;
                        $counter = 2;
                    @endphp
                    <div class="row row-cols-1 row-cols-md-4 g-4">

                        @foreach ($data->imageFile as $image)
                            <div class="col popup-container">
                                <div class="card h-100 image-container">
                                    <img src="{{URL::to('/');}}/public/images/userimage/{{$module_name}}/{{$data->id}}/{{$image}}"
                                        class="card-img-top popup-image" alt="image/*"
                                        style="width:100%;height: 100%;">

                                    <div class="popup-middle" id="popup{{ $image }}">
                                        <div class="popup-text" style="display: flex;">

                                            <form action="{{ route('backend.rooms.update_image', ['id' => $data->id]) }}"
                                                method="POST" enctype="multipart/form-data">
                                                @csrf
                                                @method('PATCH')
                                                <input type="hidden" name="update_image_name"
                                                    value="{{ $image }}">
                                                <button class="btn change-thumbnail " type="submit"
                                                    style="border: 1px solid white;width: 60px;margin: 3px;">
                                                    <i class="fas fa-edit" title="Update" data-toggle="tooltip"></i>
                                                    <input type="file" name="new_image" class="input-thumbnail"
                                                        title="@lang('labels.backend.update')" data-toggle="tooltip"
                                                        style="width: 58px;border-radius: 3px;"
                                                        onchange="javascript:this.form.submit();" accept="image/*">
                                                </button>
                                            </form>

                                            <form
                                                action="{{ route('backend.rooms.destroy_image', ['id' => $data->id]) }}"
                                                method="POST">
                                                @csrf
                                                @method('DELETE')
                                                <input type="hidden" name="delete_image_name"
                                                    value="{{ $image }}">
                                                <button class="btn change-thumbnail " type="submit"
                                                    style="border: 1px solid white;width: 60px;margin: 3px;">
                                                    <i class="fa fa-trash" aria-hidden="true" title="@lang('labels.backend.delete')"
                                                        data-toggle="tooltip"></i>
                                                </button>
                                            </form>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            @php
                                $counter++;
                            @endphp
                        @endforeach
                    </div>
                    @php
                        $counter = 0;
                    @endphp

                </div>
            @else
                @php
                    $remaining = 5;
                @endphp

            @endif
        @else
            @php
                $remaining = 5;
            @endphp

        @endif
    </div>

</div>


<!-- Select2 Library -->
<x-library.select2 />
<x-library.datetime-picker />

@push('after-styles')
    <!-- File Manager -->
    <link rel="stylesheet" href="{{ asset('vendor/file-manager/css/file-manager.css') }}">
@endpush

@push('after-scripts')
    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on('select2:open', () => {
                document.querySelector('.select2-search__field').focus();
                document.querySelector('.select2-container--open .select2-search__field').focus();
            });

            $('.select2-category').select2({
                theme: "bootstrap",
                placeholder: '@lang('Select an option')',
                minimumInputLength: 2,
                allowClear: true,
                ajax: {
                    url: '{{ route('backend.categories.index_list') }}',
                    dataType: 'json',
                    data: function(params) {
                        return {
                            q: $.trim(params.term)
                        };
                    },
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });

            $('.select2-tags').select2({
                theme: "bootstrap",
                placeholder: '@lang('Select an option')',
                minimumInputLength: 2,
                allowClear: true,
                ajax: {
                    url: '{{ route('backend.tags.index_list') }}',
                    dataType: 'json',
                    data: function(params) {
                        return {
                            q: $.trim(params.term)
                        };
                    },
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
        });
    </script>

    <!-- Date Time Picker & Moment Js-->
    <script type="text/javascript">
        $(function() {
            $('.datetime').datetimepicker({
                format: 'YYYY-MM-DD HH:mm:ss',
                icons: {
                    time: 'far fa-clock',
                    date: 'far fa-calendar-alt',
                    up: 'fas fa-arrow-up',
                    down: 'fas fa-arrow-down',
                    previous: 'fas fa-chevron-left',
                    next: 'fas fa-chevron-right',
                    today: 'far fa-calendar-check',
                    clear: 'far fa-trash-alt',
                    close: 'fas fa-times'
                }
            });
        });
    </script>

    <script type="text/javascript" src="{{ asset('vendor/ckeditor/ckeditor.js') }}"></script>
    <script type="text/javascript" src="{{ asset('vendor/file-manager/js/file-manager.js') }}"></script>

    <script type="text/javascript">
        CKEDITOR.replace('content', {
            filebrowserImageBrowseUrl: '/file-manager/ckeditor',
            language: '{{ App::getLocale() }}',
            defaultLanguage: 'en'
        });

        document.addEventListener("DOMContentLoaded", function() {

            document.getElementById('button-image').addEventListener('click', (event) => {
                event.preventDefault();

                window.open('/file-manager/fm-button', 'fm', 'width=800,height=600');
            });
        });

        // set file link
        function fmSetLink($url) {
            // document.getElementById('featured_image').value = $url;
        }
    </script>


    <script type="text/javascript">
        function add() {
            var new_chq_no = parseInt($('#total_chq').val()) + 1;
            // var new_input="<input type='text' id='new_"+new_chq_no+"'>";
            var new_input = `<button class="btn change-thumbnail upload-new-image update-btn"  type="button" id="parent${new_chq_no}">
                      <i class="fa fa-fw fa-camera" id="check-icon${new_chq_no}"></i>
                      <input type="file" name="addimage${new_chq_no}" class="input-thumbnail" onchange="changecolor.call(this,'parent${new_chq_no}','check-icon${new_chq_no}');">
                      <span>Upload Photo</span>
                  </button>`;

            const max_size = 7 - parseInt({{ $total_images }});
            if (new_chq_no < max_size) {
                $('#new_chq').append(new_input);
                $('#total_chq').val(new_chq_no)
            }
        }

        function remove() {
            var last_chq_no = $('#total_chq').val();
            if (last_chq_no > 1) {
                $('#parent' + last_chq_no).remove();
                $('#total_chq').val(last_chq_no - 1);
            }
        }
    </script>

    <script type="text/javascript">
        function changecolor(parent, child) {
            document.getElementById(parent).style.cssText =
                `background-color:#f900f3;border: none !important;color: white !important;`;
            document.getElementById(child).className = `fa-solid fa-check`;


        }
    </script>

    <script>
        var loadFile = function(event) {
            var output = document.getElementById('preview');
            output.src = URL.createObjectURL(event.target.files[0]);
            // output.onload = function() {
            //   URL.revokeObjectURL(output.src) // free memory
            // }
        };

        function deleteRoom(id){
        Swal.fire({
            icon: 'question',
            title: 'Delete',
            text: 'Do you want to Delete?',
            iconColor: '#e80202',
            position: 'top', 
            width: 300,
            // showDenyButton: true,
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Delete',
            cancelButtonText: 'Cancel',
            }).then((result) => {
            /* Read more about isConfirmed, isDenied below */
            if (result.isConfirmed) { console.log(id);
                $.ajax({
                type: "POST",
                url: "{{route('backend.rooms.delete', )}}",
                data:{'_token':"{{csrf_token()}}", 
                        id: id},
                success:function(data) {
                    if(data == "success"){
                        window.location.href='/admin/rooms';
                    }
                    else if(data == "error"){
                        window.location.reload();
                    }
                    // console.log(data);
                },
            })
            } 
            })
       
        
    }

    </script>
@endpush

<div class="row m-3">
                    

    <div class="col-12">
        <div class="float-end">

            {{-- <a href='{{route("backend.$module_name.delete", $data->id)}}' class="btn change-thumbnail" data-method="DELETE" data-token="{{csrf_token()}}" data-toggle="tooltip" title="@lang('labels.backend.delete')"><i class="fas fa-trash-alt"></i></a> --}}
            <a href='javacript:void(0)' onclick='deleteRoom("{{$data->id}}")' class="btn change-thumbnail" ><i class="fas fa-trash-alt"></i></a>

            <a href='{{ route("backend.room.index") }}' class="btn change-thumbnail" data-toggle="tooltip" title="@lang('labels.backend.cancel')"><i class="fas fa-reply"></i>@lang('labels.backend.cancel')</a>
        </div>
    </div>
</div>


</div>
</div>
</div>





<div class="card-footer">
<div class="row">
<div class="col">
<small class="float-end text-muted">
    @lang('labels.backend.users.fields.updated_at'): {{$data->updated_at->diffForHumans()}},
    @lang('labels.backend.users.fields.created_at'): {{$data->created_at->isoFormat('LLLL')}}
</small>
</div>
</div>
</div>
</div>



@endsection