@extends('backend.layouts.app')

@section('title') {{$module_action}} {{$module_title}} @endsection

@section('breadcrumbs')
<x-backend-breadcrumbs>
    <x-backend-breadcrumb-item type="active" icon='{{ $module_icon }}'>@lang('labels.text.ads')</x-backend-breadcrumb-item>
</x-backend-breadcrumbs>
@endsection

<style>
    body,table{
        color: grey !important;
        }
        table a{
        text-decoration:none;    
        color:grey;
        }
        table  a:hover{
            color:inherit;
        }
        i{
            padding:3px;
        }
        .form-select:focus {
          border-color:grey !important;
          box-shadow: none !important;
        }

        .totalCredits{
            background: #FFD700;
            color: black;
            padding: 5px 23px;
            border-radius: 5px;
        }

        .totalgredits{
            background: #FF69B4;
            color: #fff;
            padding: 5px 23px;
            border-radius: 5px;
            margin-left: 10px;
        }
        .plusIcon{
            font-size: x-large !important;
        }
        @media (max-width: 768px){
            .card-body.list .btn-toolbar.d-block a {
                width: 89px !important;
            }
            .totalCredits{
                font-size: 15px !important;
            }
            .card-body.list .btn-toolbar.d-block {
                margin-top: 10px;
            }
        }

        @media (max-width: 425px){

            .plusIcon{
                font-size: large !important;
            }
            .card-body.list .btn-toolbar.d-block {
                width: 100% !important;
            }

            .card-body.list .btn-toolbar.d-block a {
                width: 63px !important;
            }
        }

        @media (max-width: 320px){
            .card-body.list .btn-toolbar.d-block {
                width: 100% !important;
                display: flex !important;
            }

            .card-body.list .btn-toolbar.d-block a {
                width: 34px !important;
            }
        }
</style>

@section('content')


@php 
 $rolename=auth()->user()->getRoleNames()[0];
@endphp


<!--START: HEADING-->

<div class="card">
    <div class="card-body list">

        <div class="d-flex justify-content-between flex-wrap mb-3">
            <div>
                <h4 class="card-title mb-0">
                    <i class="{{ $module_icon }}"></i><small class="text-muted">@lang('labels.text.ads')</small>
                </h4>
                <div class="small text-medium-emphasis">
                   @lang('labels.text.management_dashboard')
                </div>
             </div>
        <div>
             @if($rolename=='escort')
    
                    <a class="btn change-thumbnail ms-1" href='{{ route("backend.$module_name.create") }}'
                       data-toggle="tooltip" aria-label="Create Ad" 
                      data-coreui-original-title="@lang('labels.text.create_ads')" style="box-shadow: none;border: 1px solid #3600f8 !important;background: white;color: #3600f8 !important; font-size:inherit !important;">
                            <i class="fa fa-plus-square plusIcon" aria-hidden="true" style="font-size:inherit !important;"></i>@lang('labels.text.create_ads')
                    </a>
                    @endif
    </div>
    <div class="btn-toolbar d-block" role="toolbar" aria-label="Toolbar with buttons">
       
                                        
                @if($rolename=='escort')
                <span class="totalCredits" style=""><!-- @lang('labels.text.total_credits') -->
                    @lang('labels.text.payed'):
                    @if(isset($credits)) 
                        @if($credits !=null)
                            {{$credits}}
                        @else
                            0
                        @endif
                    @endif
                </span>

                <span class="totalgredits" style="">
                @lang('labels.text.free'): 
                    @if(isset($gratis))
                         
                        @if($gratis !=null)
                            {{$gratis}}
                        @else
                            0
                        @endif
                    @endif
                </span>
             @endif
    </div>
</div>



<!--END: HEADING-->



  @if($rolename == 'super admin')


    <!--  show all posts for Admin -->

        <div class="row mt-4">
            <div class="col">
                <table id="datatable" class="table table-bordered table-hover table-responsive-sm">
                    <thead>
                        <tr>
                            <th>
                               @lang('labels.text.id')
                            </th>
                            <th>
                                @lang('labels.text.name')
                            </th>
                            <th>
                                @lang('labels.text.category')
                            </th> 
                            <th>
                               @lang('labels.text.approved')
                            </th>
    
                            <th>
                                @lang('labels.text.ad_status')
                            </th>
                            
                            <th class="text-end">
                               @lang('labels.text.action')
                            </th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>

    <!--  end show all posts for admin -->

  @endif

    <!--  show all posts for agency -->

 

    <!--  show all posts for agency -->




  @if($rolename == 'escort')
    <div class="text" style="display:none">
        <div class="alert alert-primary" role="alert">
            <p>@lang('labels.text.one_time_text_in_day')</p>
            <button type="button" class="btn btn-secondary" data-bs-dismiss="alert" aria-label="Close" onclick="setcookie()">Hide</button>
        </div>
    </div>
@php 

 $date_array=[];
 $slugarr=[];

@endphp
  
<div class="row row-cols-lg-4 row-cols-md-2 g-4">
@foreach($$module_name as $post)
     
  <div class="col d-flex justify-content-center">
    <div class="card h-100 " style="width: 230px;">
      <img src="{{ asset($thumbnailPath)}}/{{$post->id}}/{{$post->thumbnail}}" class="card-img-top" alt="image" style="height: 285px;width: 230px;">

      <div class="card-body">
        <div class="card-title d-flex justify-content-between flex-row  flex-nowrap">
            <div class="text-capitalize">{{$post->name}}</div>
              <!-- <i class="fa fa-ellipsis-v"></i> -->
            <div class="">
                <div class="text-end">
                    <button onclick="threedot{{$post->id}}()" id="threedotbutton{{$post->id}}" class="border-0" style="background-color: none;">
                        <i class="fa fa-ellipsis-v"></i>
                    </button>
                </div>
                <div id="threedotdropdonwcontent{{$post->id}}"  tabindex="-1" style="display: none;position: absolute;z-index: 1;left: 81px; background-color:white;top: 287px;">
                <a href='{!!route("backend.$module_name.show",$post->id)!!}' class="text-secondary" style="text-decoration: none;">
                    <div><i class="fas fa-desktop"></i>@lang('labels.backend.show')</div>
                </a>
                <a href='{!!route("backend.$module_name.edit",$post->id)!!}' class="text-secondary" style="text-decoration: none;">
                    <div><i class="fa fa-edit"></i> @lang('labels.backend.edit')</div>
                </a>
                <form method="POST" action='{!!route("backend.posts.destroy",$post->id)!!}'>
                    @csrf
                    @method('delete')
                    <button type="submit" class="btn btn-danger" style="border: none;background-color:white;color: grey;padding: 0px;"><div><i class="fas fa-trash-alt"></i> @lang('labels.backend.delete')</div></button>
                </form>

                </div>

                <script type="text/javascript">
                    function threedot{{$post->id}}() {
                                    const x = document.getElementById("threedotdropdonwcontent{{$post->id}}");
                                    if (x.style.display === "none") {
                                        x.style.display = "block";
                                    } else {
                                        x.style.display = "none";
                                    }
                    }
                    document.addEventListener('mouseup', function(e) {
                                    var container = document.getElementById('threedotbutton{{$post->id}}');
                                    if (!container.contains(e.target)) {
                                        const x = document.getElementById("threedotdropdonwcontent{{$post->id}}");
                                        x.style.display = "none";
                                    }
                    });
                </script>



            </div>
        </div>
       
         <div class="text-capitalize"><i class="fas fa-map-marker-alt"></i>{{$post->town}}</div>   
         <div class="d-flex justify-content-between flex-row  flex-nowrap ">
             <div>
                     <!-- countdown clock  start-->
                     @php

                     $settime=Illuminate\Support\Facades\DB::table('autorenew')->where('postid',$post->id)->value('settime');
                     $settime=(int)$settime;
                     @endphp

                  @if($settime == 720)   
                  <div><button id="inactiveclocktimer{{$post->id}}"  data-toggle="tooltip"
                        title="Ad will Disappear" class="btn-danger btn btn-sm" style="font-size: x-small;">@lang('labels.backend.clock')</button></div>
                  @else
                  <div><button id="clocktimer{{$post->id}}" class="btn-danger btn btn-sm" style="font-size: x-small;">@lang('labels.backend.clock')</button></div>   
                  @endif  
@php

  $slug=Illuminate\Support\Facades\DB::table('posts')->where('id',$post->id)->value('slug');

  if($slug == 0 || $slug == null || $slug == 'undefined'){
    $slug='empty';
  }

  $slugarr[$post->id]=$slug;

  $expire = date('Y-m-d H:i:s', strtotime("+1 day" ,strtotime('00:00')));

@endphp


        

<!-- Display the countdown timer in an element -->
                 <!-- <button  class="btn btn-danger btn-sm" id="clock{{$post->id}}"></button> -->

<script src = "https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
 <script>

function getCookie(name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++) {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1,c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
}

function setcookie(){
    if(!getCookie('visible')){
       
        document.cookie = "visible=true; expires='<?php echo $expire; ?>'; path=/";
    }
}

if(!getCookie('visible')){
        $(".text").css('display', 'block');
    }
    // console.log("<?php echo $expire; ?>");
    // console.log(getCookie('visible'));
    
    
    

setInterval(function(){

        $.ajax({
        type:'POST',
        data:{'_token':"{{csrf_token()}}"},
        url:'{{route("backend.$module_path.gettime",["slug"=> $slugarr[$post->id] ] )}}',
        success:function(data) {
            gettime{{$post->id}}(data);
        },
        error: function(data){
            console.log("error");
            // console.log(data);
        }
        });
 },1000);

function gettime{{$post->id}}(ad) {

        // console.log(ad);
        var finish{{$post->id}}=new Date();
        finish{{$post->id}}.setFullYear(ad.year,ad.month,ad.day);
        finish{{$post->id}}.setHours(ad.hour);
        finish{{$post->id}}.setMinutes(ad.minute);
        finish{{$post->id}}.setSeconds(ad.second);
        finish{{$post->id}}.toLocaleString('en',{timeZone: 'Europe/Madrid'});
        // console.log('finishtime',finish{{$post->id}});
        finish{{$post->id}}.getTime();

        var countDownDate{{$post->id}}=finish{{$post->id}};


        // Update the count down every 1 second
        var x{{$post->id}} = setInterval(function() {

          // Get today's date and time
          // var now = new Date( new Date().toLocaleString('en', {timeZone: 'Europe/Madrid'}) );
          // console.log('current data',now);
          var now{{$post->id}} = new Date( new Date().toLocaleString('en', {timeZone: 'Europe/Madrid'}) ).getTime();

          // Find the distance between now and the count down date
          var distance{{$post->id}} = countDownDate{{$post->id}} - now{{$post->id}};
          
          var time{{$post->id}} = distance{{$post->id}} / 1000;
          var day{{$post->id}} = Math.floor(time{{$post->id}} / (24*60*60));
          var checkfinishdate{{$post->id}}=day{{$post->id}};
          // console.log(checkfinishdate{{$post->id}});
          // Time calculations for days, hours, minutes and seconds
          var days{{$post->id}} = Math.floor(distance{{$post->id}} / (1000 * 60 * 60 * 24));
          var hours{{$post->id}} = Math.floor((distance{{$post->id}} % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
          var minutes{{$post->id}} = Math.floor((distance{{$post->id}} % (1000 * 60 * 60)) / (1000 * 60));
          var seconds{{$post->id}} = Math.floor((distance{{$post->id}} % (1000 * 60)) / 1000);

          // Display the result in the element with id="demo"
          if(document.getElementById("clocktimer{{$post->id}}")){

          document.getElementById("clocktimer{{$post->id}}").innerHTML =hours{{$post->id}}+':'+minutes{{$post->id}}+':'+ seconds{{$post->id}};
          }


          // if 30 day ad is running

              if(checkfinishdate{{$post->id}} < 1 && document.getElementById("inactiveclocktimer{{$post->id}}")){
                document.getElementById("inactiveclocktimer{{$post->id}}").innerHTML = `@lang('labels.backend.expired')`;    
              }else{
                    if(document.getElementById("inactiveclocktimer{{$post->id}}")){
                        document.getElementById("inactiveclocktimer{{$post->id}}").innerHTML =checkfinishdate{{$post->id}}+' days left'; 
                    }
              }

          
          
          if (distance{{$post->id}} < 0) {
            clearInterval(x{{$post->id}});
            if(document.getElementById("clocktimer{{$post->id}}")){
            document.getElementById("clocktimer{{$post->id}}").innerHTML = `@lang('labels.backend.expired')`;
            }    

    }
            }, 1000);
}

</script>
 
 

<!-- countdown clock end -->
             </div>
             <div class="renew-autorenew" style="display: flex;justify-content: space-around;
    width: 50%;">
                <a href='{!!route("backend.$module_name.autorenew",$post->id)!!}'
                       class='small'
                        title="@lang('labels.text.auto_renew_post')"                   
                       data-toggle="tooltip"
                       style="color:green;background-color:none;border:none" >
                        <i class="fa fa-refresh"></i>
                </a>
                {{--
                 <a href='{!!route("backend.$module_name.freerenew", $post->id)!!}'
                       class='small'
                       title="@lang('labels.text.free_renew_post')"
                       data-toggle="tooltip"
                       style="color:grey;background-color:none;border:none" >
                        <i class="fa fa-refresh"></i>
                </a>
                --}}
             </div>
         </div>
      </div>
    </div>
  </div>
@endforeach
</div>




@endif

    <!--  end show all posts for admin -->

    </div>
    <div class="card-footer">
        <div class="row">
            <div class="col-7">
                <div class="float-left">

                </div>
            </div>
            <div class="col-5">
                <div class="float-end">
                   

                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push ('after-styles')
<!-- DataTables Core and Extensions -->
<link rel="stylesheet" href="{{ asset('vendor/datatable/datatables.min.css') }}">
<link
            href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css"
            rel="stylesheet"
            integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC"
            crossorigin="anonymous"
        />


@endpush

@push ('after-scripts')

 <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>


<!-- DataTables Core and Extensions -->
<script type="text/javascript" src="{{ asset('vendor/datatable/datatables.min.js') }}"></script>

@if($rolename == 'super admin')

<script type="text/javascript">

    $('#datatable').DataTable({
        processing: true,
        serverSide: true,
        autoWidth: true,
        responsive: true,
        ajax: '{{ route("backend.$module_name.index_data") }}',
        columns: [{
                data: 'id',
                name: 'id'
            },
            {
                data: 'name',
                name: 'name'
            },
            {
                data: 'category',
                name: 'category'
            },

            {
                data: 'approve',
                name: 'approve'
            },
            {
                data: 'ad_status',
                name: 'ad_status'
            },
            {
                data: 'action',
                name: 'action',
                orderable: false,
                searchable: false
            }
        ]

    });
</script>

@endif


@if($rolename == 'escort')



@endif
 
 


@endpush