@extends('backend.layouts.app')

@section('title') {{gt::trans($module_action,app()->getLocale())}} {{gt::trans($module_title,app()->getLocale())}} @endsection

@section('breadcrumbs')
<x-backend-breadcrumbs>
    <x-backend-breadcrumb-item route='{{route("backend.$module_name.index")}}' icon='{{ $module_icon }}'>
       {{gt::trans($module_title,app()->getLocale())}}
    </x-backend-breadcrumb-item>
    <x-backend-breadcrumb-item type="active">{{gt::trans($module_action,app()->getLocale())}}</x-backend-breadcrumb-item>
</x-backend-breadcrumbs>
@endsection

@section('content')

<!--  same css apply in edit.balde.php -->
<style type="text/css">
    .form-control:focus {
    background-color: #fff;
    border-color: #f700f0;
     box-shadow:unset; 
}
.select2-container--bootstrap .select2-results__option--highlighted[aria-selected] {
    background-color: #f800f2;
}
.select2-container--bootstrap.select2-container--focus .select2-selection, .select2-container--bootstrap.select2-container--open .select2-selection {
    border-color: #f800f2;
}
.select2-container--bootstrap .select2-dropdown {
    border-color: #f800f2;
}

.text-danger {
    display: none;
}

.form-group {
    padding: 0px;
    padding-bottom: 1rem;
}
.change-thumbnail {
       box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important; 
}
.change-thumbnail:hover,.change-thumbnail:focus,.change-thumbnail:visited{
    box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important; 
}
.change-thumbnail:active{
   box-shadow: none;
    border: 1px solid #f800f2 !important;
    background: white;
    color: #f800f2 !important;   
}
.input-thumbnail {
        opacity: 0;
        position: absolute;
        display: inline-block;
        width: 149px;
        padding: 0px;
        margin: -4px;
        margin-left: -37px;
        cursor: pointer;
}
span.select2.select2-container.select2-container--bootstrap{
    width: auto !important;
}
label,.form-check-label {
    color: grey;
}

.form-check-input{
    background-color: white;
}
.form-check-input:focus {
    background-color: #ffffff;
    border-color: #80808096;
    box-shadow: none;
}
.form-check-input:checked{
    background-color: #f800f2;
    border-color: #f800f2;
    box-shadow: none;
}


</style>


<div class="card-body list">
    <h4 class="text-center text-danger">{{gt::trans('ATTENTION',app()->getLocale())}}:</h4>
    <p class="text-center text-danger">{{gt::trans('As a result of the new law, nude images and some others that may be particularly provocative will no longer be displayed on our website. However, we will still accept photos of people in lingerie and bikinis, as long as they are less suggestive. We reserve the right to decide which images are appropriate for our site and which are not. Sorry for any inconvenience this may cause.',app()->getLocale())}}</p>
    <p class="text-center text-danger">{{gt::trans('On the other hand, we would like to emphasize that professional photographs will have priority on our website. Therefore, if you have a quality photo shoot, feel free to submit it for review. Thanks for your understanding!
  ',app()->getLocale())}}
          </p>
    <!-- <p class="text-center text-danger"><b>**professional photos will have priority**</b></p> -->
</div>




<div class="card">
    <div class="card-body">

        <x-backend.section-header>
            <i class="{{ $module_icon }}"></i> {{gt::trans($module_title,app()->getLocale())}} <small class="text-muted">{{gt::trans($module_action,app()->getLocale())}}</small>

            <x-slot name="subtitle">
                {{--@lang(":module_name Management Dashboard", ['module_name'=>Str::title($module_name)])--}}
                {{gt::trans($module_title.'Management Dashboard'app()->getLocale())}}
            </x-slot>
            <x-slot name="toolbar">
                <button onclick="window.history.back();" class="btn change-thumbnail ms-1 " data-toggle="tooltip" aria-label="Return Back" data-coreui-original-title="Return Back"><i class="fas fa-reply"></i>&nbsp;</button>

                <a href='{{ route("backend.$module_name.index") }}' class="btn change-thumbnail ms-1" data-toggle="tooltip" title="{{ __($module_title) }} List"><i class="fas fa-list-ul"></i> {{gt::trans('List',app()->getLocale())}}</a>
            </x-slot>
        </x-backend.section-header>

        <hr>






 @if ($message = Session::get('success'))
      
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <strong>{{ $message }}</strong>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
  
    <!--<div class="row">-->
    <!--    <div class="col-md-4">-->
    <!--        <strong>Original Image:</strong>-->
    <!--        <br/>-->
    <!--        <img src="/images/{{ Session::get('imageName') }}" width="300px" />-->
    <!--    </div>-->
    <!--    <div class="col-md-4">-->
    <!--        <strong>Thumbnail Image:</strong>-->
    <!--        <br/>-->
    <!--        <img src="/thumbnail/{{ Session::get('imageName') }}" />-->
    <!--    </div>-->
    <!--</div>-->
    @endif
    
     @if ($message = Session::get('danger'))
      
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <strong>{{ $message }}</strong>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
   
    @endif
            
    

        <div class="row mt-4">
            <div class="col">
                <form method="Post" action='{{route("backend.$module_name.storeRoom")}}' class="form" enctype="multipart/form-data" >
                    @csrf
                
                    <div class="d-flex justify-content-center">
                        <div class="col-md-3 border-right">
                            <div class="d-flex flex-column align-items-center text-center p-3">
                                <img class="rounded-circle" width="150px" src="{{asset('img/user.png')}}" id="preview">
                                <div class="mt-2 text-center">
                                    <button class="btn change-thumbnail " type="button" id="thumbnailimage-image">
                                        <i class="fa fa-fw fa-camera" id="change-to-check"></i>
                                        <!-- <i class="fa-solid fa-check"></i> -->
                                        <input type="file" name="thumbnailimage" class="input-thumbnail" accept="image/*" required 
                                        onchange="changecolor.call(this,'thumbnailimage-image','change-to-check');loadFile(event)">
                                        <span>Upload Photo</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="form-group">
                                
                                <?php
                                $field_name = 'name';
                                $field_lable = __("article::$module_name.$field_name");
                                $field_placeholder = $field_lable;
                                $required = 'required';
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->text($field_name)->placeholder($field_placeholder)->class('form-control')->attributes(["$required"]) }}
                            </div>
                        </div>

                    
                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="form-group text-capitalize">
                            <?php
                                $field_name = 'town';
                                $field_lable = __('Town(1)');
                                $field_placeholder = __('Town(1)');
                                $required = 'required';
                                $select_options = [];

                                    foreach ($cities as $cityobj) {
                                        $select_options[$cityobj->city]=$cityobj->city;
                                    }

                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->select($field_name, $select_options)->placeholder($field_placeholder)->class('form-control select2')->attributes(["$required"]) }}
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="form-group">
                                <?php
                                $field_name = 'category';
                                $field_lable = __('Category');
                                $field_placeholder = __('Select an option');
                                $required = 'required';
                                $select_options = [
                                    'women' => 'Women',
                                    'men' => 'Men',
                                    'gay' =>'Gay',
                                    'lesbian' =>'Lesbian',
                                    'trans/trav' => 'Trans/Trav',
                                    'couples' => 'Couples',
                                    'videocall' => 'VideoCall',
                                    'rooms' => 'Rooms',
                                    'massage' => 'Massage'
                                ];
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->select($field_name, $select_options)->placeholder($field_placeholder)->class('form-control select2')->attributes(["$required"]) }}
                            </div>
                        </div>
                        
                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                        <div class="form-group">
                                <?php
                                $field_name = 'zone';
                                $field_lable = __('Zone(2)');
                                $field_placeholder = 'Zone(2)';
                                $required = 'required';
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->text($field_name)->placeholder($field_placeholder)->class('form-control')->attributes(["$required"]) }}
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="form-group ">
                                <?php
                                $field_name = 'rates';
                                $field_lable = __('Rates(€)');
                                $field_placeholder = __('Rate');
                                $required = 'required';
                                $select_options = [
                    "10"=>"10",
                    "20"=>"20",
                    "30"=>"30",
                    "40"=>"40",
                    "50"=>"50",
                    "60"=>"60",
                    "70"=>"70",
                    "80"=>"80",
                    "90"=>"90",
                    "100"=>"100",
                    "110"=>"110",
                    "120"=>"120",
                    "130"=>"130",
                    "140"=>"140",
                    "150"=>"150",
                    "160"=>"160",
                    "170"=>"70",
                    "180"=>"180",
                    "190"=>"190",
                    "200"=>"200",
                    "300"=>"300",
                    "400"=>"400",
                    "500"=>"500",
                    "1000"=>"1000"
                                ];
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->select($field_name, $select_options)->placeholder($field_placeholder)->class('form-control select2')}}
                            </div>                                   
                        </div>
                        

                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="form-group">
                                <?php
                                $field_name = 'phone';
                                $field_lable = __('Phone Number');
                                $field_placeholder = $field_lable;
                                $required = 'required';
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->number($field_name)->placeholder($field_placeholder)->class('form-control')->attributes(["$required"]) }}
                            </div>
                        </div>
                        
                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="form-group">
                                <?php
                                $field_name = 'age';
                                $field_lable = __('Age');
                                $field_placeholder = __('Age');
                                $required = 'required';
                                $select_options = [];
                                foreach (range(18,88) as $age) {
                                    $select_options[$age]=$age;
                                }
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->select($field_name, $select_options)->placeholder($field_placeholder)->class('form-control select2')}}

                            </div>
                        </div>

                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="form-group">
                                <?php
                                $field_name = 'language';
                                $field_lable = __('Language');
                                $field_placeholder =__('English,Spanish');
                                $required = 'required';
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->text($field_name)->placeholder($field_placeholder)->class('form-control')->attributes(["$required"]) }}
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6 ">
                            <div class="form-group">
                                <?php
                                $field_name = 'hair';
                                $field_lable = __('Hair Color');
                                $field_placeholder = __('Hair Color');
                                $required = 'required';
                                $select_options = [
                                'blonde' =>'Blonde',
                                'brunette' =>'Brunette',
                                'redhead' =>'Redhead',
                                ];
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->select($field_name, $select_options)->placeholder($field_placeholder)->class('form-control select2')->attributes(["$required"]) }}
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6 ">
                            <div class="form-group">
                                <?php
                                $field_name = 'eye';
                                $field_lable = __('Eye Color');
                                $field_placeholder = __('Eye Color');
                                $required = 'required';
                                $select_options = [
                                'blues' =>'Blues',
                                'browns' =>'Browns',
                                'green' =>'Green',
                                'black' =>'Black',
                                ];
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->select($field_name, $select_options)->placeholder($field_placeholder)->class('form-control select2')->attributes(["$required"]) }}
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="form-group">
                                <?php
                                $field_name = 'whatsapp';
                                $field_lable = __('whatsapp Consent');
                                $field_placeholder = __('Whatsapp Consent');
                                $required = 'required';
                                $select_options = [
                                    'yes' => 'Yes',
                                    'no' => 'No',
                                ];
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->select($field_name, $select_options)->placeholder($field_placeholder)->class('form-control select2')->attributes(["$required"]) }}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="form-group">
                                <?php
                                $field_name = 'share';
                                $field_lable = __('Share Profile');
                                $field_placeholder = __('Share Profile');
                                $required = 'required';
                                $select_options = [
                                    'yes' => 'Yes',
                                    'no' => 'No',
                                ];
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->select($field_name, $select_options)->placeholder($field_placeholder)->class('form-control select2')->attributes(["$required"]) }}
                            </div>
                        </div>    

                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="form-group">
                                <?php
                                $field_name = ' smoking';
                                $field_lable = __('Smoking');
                                $field_placeholder = __('Smoking');
                                $required = 'required';
                                $select_options = [
                                    'yes' => 'Yes',
                                    'no' => 'No',
                                ];
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->select($field_name, $select_options)->placeholder($field_placeholder)->class('form-control select2')->attributes(["$required"]) }}
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6 ">
                            <div class="form-group">
                                <?php
                                $field_name = 'nationality';
                                $field_lable = __('Nationality');
                                $field_placeholder = __('Nationality');
                                $required = 'required';
                                $select_options = [];

                                    foreach ($countries as $country) {
                                        $select_options[$country->name]=$country->name;
                                    }

                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->select($field_name, $select_options)->placeholder($field_placeholder)->class('form-control select2')->attributes(["$required"]) }}
                            </div>
                        </div>
                        
                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="form-group">
                                <?php
                                $field_name = 'height';
                                $field_lable = __('Height(cm)');
                                $field_placeholder = __('height');
                                $required = 'required';
                                $select_options = [];
                                foreach (range(150,190) as $height) {
                                    $select_options[$height]=$height." cm";
                                }
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->select($field_name, $select_options)->placeholder($field_placeholder)->class('form-control select2')}}
                            </div>
                        </div>
                        
                        @if($userAccountGender != null)
                        
                        
                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="form-group">
                                <?php
                                $field_name = 'chest';
                                $field_lable = __('Chest(cm)');
                                $field_placeholder = __('Chest');
                                $required = 'required';
                                $select_options = [];
                                $select_options['null']="Empty";
                                foreach (range(70,150) as $chest) {
                                    $select_options[$chest]=$chest." cm";
                                }
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->select($field_name, $select_options)->placeholder($field_placeholder)->class('form-control select2')}}
                            </div>
                        </div>
                    
                        
                        @endif
                        
                        @if($userAccountGender != null)
                        
                    
                        <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                            <div class="form-group">
                                <?php
                                $field_name = ' natural_breast';
                                $field_lable = __('Natural Breast');
                                $field_placeholder = __('Natural Breast');
                                $required = 'required';
                                $select_options = [
                                    'yes' => 'Yes',
                                    'no' => 'No',
                                    'null'=>'Empty'
                                ];
                                ?>
                                {{ html()->label($field_lable, $field_name) }} {!! fielf_required($required) !!}
                                {{ html()->select($field_name, $select_options)->placeholder($field_placeholder)->class('form-control select2')->attributes(["$required"]) }}
                            </div>
                        </div>
                        
                        
                        @endif

                    

                        <div class="col-12">
                            <label class="mt-2">Types of Payment Receive</label> 
                            <div class="">
                                            <input class="form-check-input" type="checkbox" name="paymenttypes[]" value="bitcoin" id="bitcoin">
                                            <label class="form-check-label d-inline" for="bitcoin">BITCOIN</label>
                                        
                                            <input class="form-check-input" type="checkbox" name="paymenttypes[]" value="visa" id="visa" />
                                            <label class="form-check-label d-inline" for="visa">VISA</label>
                                        
                                            <input class="form-check-input" type="checkbox" name="paymenttypes[]" value="paypal" id="paypal">
                                            <label class="form-check-label d-inline" for="paypal">PAYPAL</label>
                                        
                                            <input class="form-check-input" type="checkbox" name="paymenttypes[]" value="efectivo" id="efectivo">
                                            <label class="form-check-label d-inline" for="efectivo">EFECTIVO</label>
                                        
                                            <input class="form-check-input" type="checkbox" name="paymenttypes[]" value="bizum" id="bizum">
                                            <label class="form-check-label d-inline" for="bizum">BIZUM</label>
                                        
                                            <input class="form-check-input" type="checkbox" name="paymenttypes[]" value="revolut" id="revolut">
                                            <label class="form-check-label d-inline" for="revolut">REVOLUT</label>
                                            
                                            <input class="form-check-input" type="checkbox" name="paymenttypes[]" value=" verse" id="verse">
                                            <label class="form-check-label d-inline" for="verse"> VERSE</label>
                            </div>    
                        </div>
                        <div class="col-12">
                            <label class="mt-2">Metting Place</label>
                                <div class="">
                                    <input class="form-check-input" type="checkbox" name="metting_place[]" value="private apartment" id="flexCheckDefault1">
                                    <label class="form-check-label" for="flexCheckDefault1">Private apartment</label>
                                    
                                    <input class="form-check-input" type="checkbox" name="metting_place[]" value="customer address" id="Customeraddress">
                                    <label class="form-check-label" for="Customeraddress">Customer address</label>
                                    
                                    <input class="form-check-input" type="checkbox" name="metting_place[]" value="room by the hour" id="flexCheckChecked">
                                    <label class="form-check-label" for="flexCheckChecked">Room by the hour</label>
                                        
                                    <input class="form-check-input" type="checkbox" name="metting_place[]"  value="hotel" id="hotel">
                                    <label class="form-check-label" for="hotel">Hotel</label>


                                        
                                </div>
                        </div>
                        <div class="col-12">
                            <label class="mt-2">Add Images</label> 
                            <div class="modal-title" id="form-area">
                                <button type="button" onclick="add();" class="btn update-btn change-thumbnail">ADD <i class="fa fa-plus-circle"></i></button>
                                <button type="button" onclick="remove();" class="btn update-btn change-thumbnail">Remove <i class="fa fa-minus-circle"></i></button>
                            </div>
                            <div class="modal-body" style="display: flex;justify-content: center;">
                                <div id="new_chq" ></div>
                                <input type="hidden" value="1" id="total_chq">
                        </div>

                        </div>
                        <div class="col-12">
                                    <div class="p-1"> 
                                        <div class="form-group">
                                        <label for="text_content">Message( <small class="tex-muted">Limit 500 Characters</small>)</label>
                                        <textarea class="form-control" required id="text_content" name="text_content" rows="4" maxlength="500"></textarea>
                                        </div>                        
                                    </div>
                                    <div class="p-1 pt-4"> 
                                        <p  style="background: #fa00f575;color: white;border-radius: 5px;padding: 8px;font-size: smaller;">
                                            On this website, we take the respect and integrity of all our users very seriously. Therefore, we want to make it clear that the use of words with SEXUAL content or any other type of inappropriate language is strictly prohibited.We reserve the right to ban any user who violates this rule. We expect all of our users to behave responsibly and respectfully in order to maintain a safe and enjoyable environment for all.Thank you for your understanding and cooperation in this matter.
                                        </p>                        
                                    </div>
                        </div>


                    </div>






                    <div></div>


                    <!-- Select2 Library -->
                    <x-library.select2 />
                    <x-library.datetime-picker />

                    @push('after-styles')
                        <!-- File Manager -->
                        <link rel="stylesheet" href="{{ asset('vendor/file-manager/css/file-manager.css') }}">
                    @endpush

                    @push('after-scripts')
                        <script type="text/javascript">
                            $(document).ready(function() {
                                $(document).on('select2:open', () => {
                                    document.querySelector('.select2-search__field').focus();
                                    document.querySelector('.select2-container--open .select2-search__field').focus();
                                });

                                $('.select2-category').select2({
                                    theme: "bootstrap",
                                    placeholder: '@lang('Select an option')',
                                    minimumInputLength: 2,
                                    allowClear: true,
                                    ajax: {
                                        url: '{{ route('backend.categories.index_list') }}',
                                        dataType: 'json',
                                        data: function(params) {
                                            return {
                                                q: $.trim(params.term)
                                            };
                                        },
                                        processResults: function(data) {
                                            return {
                                                results: data
                                            };
                                        },
                                        cache: true
                                    }
                                });

                                $('.select2-tags').select2({
                                    theme: "bootstrap",
                                    placeholder: '@lang('Select an option')',
                                    minimumInputLength: 2,
                                    allowClear: true,
                                    ajax: {
                                        url: '{{ route('backend.tags.index_list') }}',
                                        dataType: 'json',
                                        data: function(params) {
                                            return {
                                                q: $.trim(params.term)
                                            };
                                        },
                                        processResults: function(data) {
                                            return {
                                                results: data
                                            };
                                        },
                                        cache: true
                                    }
                                });
                            });
                        </script>

                        <!-- Date Time Picker & Moment Js-->
                        <script type="text/javascript">
                            $(function() {
                                $('.datetime').datetimepicker({
                                    format: 'YYYY-MM-DD HH:mm:ss',
                                    icons: {
                                        time: 'far fa-clock',
                                        date: 'far fa-calendar-alt',
                                        up: 'fas fa-arrow-up',
                                        down: 'fas fa-arrow-down',
                                        previous: 'fas fa-chevron-left',
                                        next: 'fas fa-chevron-right',
                                        today: 'far fa-calendar-check',
                                        clear: 'far fa-trash-alt',
                                        close: 'fas fa-times'
                                    }
                                });
                            });
                        </script>

                        <script type="text/javascript" src="{{ asset('vendor/ckeditor/ckeditor.js') }}"></script>
                        <script type="text/javascript" src="{{ asset('vendor/file-manager/js/file-manager.js') }}"></script>

                        <script type="text/javascript">
                            CKEDITOR.replace('content', {
                                filebrowserImageBrowseUrl: '/file-manager/ckeditor',
                                language: '{{ App::getLocale() }}',
                                defaultLanguage: 'en'
                            });

                            document.addEventListener("DOMContentLoaded", function() {

                                document.getElementById('button-image').addEventListener('click', (event) => {
                                    event.preventDefault();

                                    window.open('/file-manager/fm-button', 'fm', 'width=800,height=600');
                                });
                            });

                            // set file link
                            function fmSetLink($url) {
                                // document.getElementById('featured_image').value = $url;
                            }
                        </script>


                        <script type="text/javascript">

                        function add(){
                            var new_chq_no =parseInt($('#total_chq').val())+1;
                            // var new_input="<input type='text' id='new_"+new_chq_no+"'>";
                            var new_input=`<button class="btn change-thumbnail upload-new-image update-btn" style="margin:5px;"  type="button" id="parent${new_chq_no}">
                                        <i class="fa fa-fw fa-camera" id="change-to-check${new_chq_no}"></i>
                                        <input type="file" name="imageFile${new_chq_no}" class="input-thumbnail" onchange="changecolor.call(this,'parent${new_chq_no}','change-to-check${new_chq_no}');">
                                        <span>Upload Photo</span>
                                    </button>`;

                                const max_size=7;    
                            if(new_chq_no <max_size){
                                    $('#new_chq').append(new_input);
                                    $('#total_chq').val(new_chq_no)
                            }     
                            }
                            function remove(){
                            var last_chq_no = $('#total_chq').val();
                            if(last_chq_no>1){
                                $('#parent'+last_chq_no).remove();
                                $('#total_chq').val(last_chq_no-1);
                            }
                            }
                    </script>

                    <script type="text/javascript">
                        function changecolor(parent,icon){
                            let element=document.getElementById(parent);
                            element.style.cssText=`background-color:#f900f3;color:white !important;border:white !important;margin:5px;`;

                            document.getElementById(icon).className=`fa-solid fa-check`;
                        }
                    </script>

                    <script>
                    var loadFile = function(event) {
                        var output = document.getElementById('preview');
                        output.src = URL.createObjectURL(event.target.files[0]);
                        // output.onload = function() {
                        //   URL.revokeObjectURL(output.src) // free memory
                        // }
                    };
                    </script>


                    @endpush

                

                <div class="row mt-1">
                    <div class="col-6 text-align-end">
                        <div class="form-group">
                            {{ html()->button($text = "<i class='fas fa-save'></i> " . ucfirst($module_action) . "", $type = 'submit')->class('btn change-thumbnail') }}
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="float-end">
                            <div class="form-group">
                                <button type="button" class="btn change-thumbnail" onclick="history.back(-1)"><i class="fas fa-reply"></i> Cancel</button>
                            </div>
                        </div>
                    </div>
                </div>

                </form>

            </div>
        </div>
    </div>

    <div class="card-footer">
        <div class="row">
            <div class="col">

            </div>
        </div>
    </div>
</div>

@endsection