<?php
/**
 * This file is part of the Cloudinary PHP package.
 *
 * (c) Cloudinary
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Cloudinary\Transformation;

/**
 * Trait FoodObjectGravityBuilderTrait
 *
 * @api
 */
trait FoodObjectGravityBuilderTrait
{
    /**
     * Gravity food.
     *
     * @return string
     */
    public static function food()
    {
        return ObjectGravity::FOOD;
    }

    /**
     * Gravity banana.
     *
     * @return string
     */
    public static function banana()
    {
        return ObjectGravity::BANANA;
    }

    /**
     * Gravity apple.
     *
     * @return string
     */
    public static function apple()
    {
        return ObjectGravity::APPLE;
    }

    /**
     * Gravity sandwich.
     *
     * @return string
     */
    public static function sandwich()
    {
        return ObjectGravity::SANDWICH;
    }

    /**
     * Gravity orange.
     *
     * @return string
     */
    public static function orange()
    {
        return ObjectGravity::ORANGE;
    }

    /**
     * Gravity broccoli.
     *
     * @return string
     */
    public static function broccoli()
    {
        return ObjectGravity::BROCCOLI;
    }

    /**
     * Gravity carrot.
     *
     * @return string
     */
    public static function carrot()
    {
        return ObjectGravity::CARROT;
    }

    /**
     * Gravity hotdog.
     *
     * @return string
     */
    public static function hotdog()
    {
        return ObjectGravity::HOTDOG;
    }

    /**
     * Gravity pizza.
     *
     * @return string
     */
    public static function pizza()
    {
        return ObjectGravity::PIZZA;
    }

    /**
     * Gravity donut.
     *
     * @return string
     */
    public static function donut()
    {
        return ObjectGravity::DONUT;
    }

    /**
     * Gravity cake.
     *
     * @return string
     */
    public static function cake()
    {
        return ObjectGravity::CAKE;
    }
}
